"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _api = require("../../../services/api");
var _documentation = require("../../../services/documentation");
var _home = require("../home");
var _data_stream_table = require("./data_stream_table");
var _data_stream_detail_panel = require("./data_stream_detail_panel");
var _data_streams = require("../../../lib/data_streams");
var _components = require("../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamList = ({
  match: {
    params: {
      dataStreamName
    }
  },
  location: {
    search
  },
  history
}) => {
  const {
    isDeepLink,
    includeHidden
  } = (0, _shared_imports.extractQueryParams)(search);
  const decodedDataStreamName = (0, _shared_imports.attemptToURIDecode)(dataStreamName);
  const {
    core: {
      getUrlForApp,
      executionContext
    },
    plugins: {
      isFleetEnabled
    }
  } = (0, _app_context.useAppContext)();
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'indexManagementDataStreamsTab'
  });
  const [isIncludeStatsChecked, setIsIncludeStatsChecked] = (0, _react.useState)(false);
  const {
    error,
    isLoading,
    data: dataStreams,
    resendRequest: reload
  } = (0, _api.useLoadDataStreams)({
    includeStats: isIncludeStatsChecked
  });
  const [filters, setFilters] = (0, _react.useState)({
    managed: {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.viewManagedLabel', {
        defaultMessage: 'Fleet-managed data streams'
      }),
      checked: 'on'
    },
    hidden: {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.viewHiddenLabel', {
        defaultMessage: 'Hidden data streams'
      }),
      checked: includeHidden ? 'on' : 'off'
    }
  });
  const activateHiddenFilter = shouldBeActive => {
    if (shouldBeActive && filters.hidden.checked === 'off') {
      setFilters({
        ...filters,
        hidden: {
          ...filters.hidden,
          checked: 'on'
        }
      });
    }
  };
  const filteredDataStreams = (0, _react.useMemo)(() => {
    if (!dataStreams) {
      // If dataStreams are not fetched, return empty array.
      return [];
    }
    const visibleTypes = Object.entries(filters).filter(([name, _filter]) => _filter.checked === 'on').map(([name]) => name);
    return (0, _data_streams.filterDataStreams)(dataStreams, visibleTypes);
  }, [dataStreams, filters]);
  const renderHeader = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.dataStreamsDescription",
      defaultMessage: "Data streams store time-series data across multiple indices. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getDataStreamsDocumentationLink(),
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamListDescription.learnMoreLinkText', {
          defaultMessage: 'Learn more.'
        }))
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.idxMgmt.dataStreamListControls.includeStatsSwitchLabel', {
        defaultMessage: 'Include stats'
      }),
      checked: isIncludeStatsChecked,
      onChange: e => setIsIncludeStatsChecked(e.target.checked),
      "data-test-subj": "includeStatsSwitch"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.idxMgmt.dataStreamListControls.includeStatsSwitchToolTip', {
        defaultMessage: 'Including stats can increase reload times'
      }),
      position: "top"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.FilterListButton, {
      filters: filters,
      onChange: setFilters
    })));
  };
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.loadingDataStreamsDescription",
      defaultMessage: "Loading data streams\u2026"
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.loadingDataStreamsErrorMessage",
        defaultMessage: "Error loading data streams"
      }),
      error: error
    });
  } else if (Array.isArray(dataStreams) && dataStreams.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "title"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsTitle",
        defaultMessage: "You don't have any data streams yet"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsDescription",
        defaultMessage: "Data streams store time-series data across multiple indices."
      }), ' ' /* We need this space to separate these two sentences. */, isFleetEnabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaIngestManagerMessage",
        defaultMessage: "Get started with data streams in {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "dataStreamsEmptyPromptTemplateLink",
            href: getUrlForApp('fleet')
          }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaIngestManagerLink', {
            defaultMessage: 'Fleet'
          }))
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaIndexTemplateMessage",
        defaultMessage: "Get started with data streams by creating a {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
            "data-test-subj": "dataStreamsEmptyPromptTemplateLink"
          }, (0, _shared_imports.reactRouterNavigate)(history, {
            pathname: '/templates'
          })), _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaIndexTemplateLink', {
            defaultMessage: 'composable index template'
          }))
        }
      })),
      "data-test-subj": "emptyPrompt"
    });
  } else {
    activateHiddenFilter((0, _data_streams.isSelectedDataStreamHidden)(dataStreams, decodedDataStreamName));
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      hasShadow: false,
      paddingSize: "none",
      "data-test-subj": "dataStreamList"
    }, renderHeader(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_data_stream_table.DataStreamTable, {
      filters: isDeepLink && decodedDataStreamName !== undefined ? `name="${decodedDataStreamName}"` : '',
      dataStreams: filteredDataStreams,
      reload: reload,
      history: history,
      includeStats: isIncludeStatsChecked
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _shared_imports.APP_WRAPPER_CLASS
  }, content, decodedDataStreamName && /*#__PURE__*/_react.default.createElement(_data_stream_detail_panel.DataStreamDetailPanel, {
    dataStreamName: decodedDataStreamName,
    onClose: shouldReload => {
      history.push(`/${_home.Section.DataStreams}`);

      // If the data stream was deleted, we need to refresh the list.
      if (shouldReload) {
        reload();
      }
    }
  }));
};
exports.DataStreamList = DataStreamList;