"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepReview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../../../common/lib");
var _common = require("../../../../../common");
var _index_templates = require("../../index_templates");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  stripEmptyFields
} = _shared_imports.serializers;
const NoneDescriptionText = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.noneDescriptionText",
  defaultMessage: "None"
});
const getDescriptionText = data => {
  const hasEntries = data && Object.entries(data).length > 0;
  return hasEntries ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.yesDescriptionText",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.noDescriptionText",
    defaultMessage: "No"
  });
};
const PreviewTab = ({
  template
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "previewTab"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.previewTab.descriptionText",
    defaultMessage: "This is the final template that will be applied to matching indices. Component templates are applied in the order specified. Explicit mappings, settings, and aliases override the component templates."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_index_templates.SimulateTemplate, {
    template: template
  }));
};
const StepReview = /*#__PURE__*/_react.default.memo(({
  template,
  navigateToStep
}) => {
  const {
    name,
    indexPatterns,
    version,
    order,
    priority,
    composedOf,
    _meta,
    _kbnMeta: {
      isLegacy
    }
  } = template;
  const serializedTemplate = isLegacy ? (0, _lib.serializeLegacyTemplate)(stripEmptyFields(template, {
    types: ['string']
  })) : (0, _lib.serializeTemplate)(stripEmptyFields(template, {
    types: ['string']
  }));
  const serializedMappings = (0, _common.getTemplateParameter)(serializedTemplate, 'mappings');
  const serializedSettings = (0, _common.getTemplateParameter)(serializedTemplate, 'settings');
  const serializedAliases = (0, _common.getTemplateParameter)(serializedTemplate, 'aliases');
  const numIndexPatterns = indexPatterns.length;
  const hasWildCardIndexPattern = Boolean(indexPatterns.find(pattern => pattern === '*'));
  const SummaryTab = () => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "summaryTab"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.indexPatternsLabel",
    defaultMessage: "Index {numIndexPatterns, plural, one {pattern} other {patterns}}",
    values: {
      numIndexPatterns
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, numIndexPatterns > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, indexPatterns.map((indexName, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `${indexName}-${i}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, indexName)));
  }))) : indexPatterns.toString()), isLegacy ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.orderLabel",
    defaultMessage: "Order"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, order ? order : /*#__PURE__*/_react.default.createElement(NoneDescriptionText, null))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.priorityLabel",
    defaultMessage: "Priority"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, priority ? priority : /*#__PURE__*/_react.default.createElement(NoneDescriptionText, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.versionLabel",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, version ? version : /*#__PURE__*/_react.default.createElement(NoneDescriptionText, null)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.componentsLabel",
    defaultMessage: "Component templates"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, composedOf && composedOf.length > 0 ? composedOf.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, composedOf.map((component, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `${component}-${i}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, component)));
  }))) : composedOf.toString() : /*#__PURE__*/_react.default.createElement(NoneDescriptionText, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.settingsLabel",
    defaultMessage: "Index settings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, getDescriptionText(serializedSettings)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.mappingLabel",
    defaultMessage: "Mappings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, getDescriptionText(serializedMappings)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.aliasesLabel",
    defaultMessage: "Aliases"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, getDescriptionText(serializedAliases)), isLegacy !== true && _meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "metaTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.metaLabel",
    defaultMessage: "Metadata"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, JSON.stringify(_meta, null, 2))))))));
  const RequestTab = () => {
    const esApiEndpoint = isLegacy ? '_template' : '_index_template';
    const endpoint = `PUT ${esApiEndpoint}/${name || '<templateName>'}`;
    const templateString = JSON.stringify(serializedTemplate, null, 2);
    const request = `${endpoint}\n${templateString}`;

    // Beyond a certain point, highlighting the syntax will bog down performance to unacceptable
    // levels. This way we prevent that happening for very large requests.
    const language = request.length < 60000 ? 'json' : undefined;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "requestTab"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateForm.stepReview.requestTab.descriptionText",
      defaultMessage: "This request will create the following index template."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: language,
      isCopyable: true
    }, request));
  };
  const tabs = [{
    id: 'summary',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepReview.summaryTabTitle', {
      defaultMessage: 'Summary'
    }),
    content: /*#__PURE__*/_react.default.createElement(SummaryTab, null)
  }, {
    id: 'request',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepReview.requestTabTitle', {
      defaultMessage: 'Request'
    }),
    content: /*#__PURE__*/_react.default.createElement(RequestTab, null)
  }];
  if (!isLegacy) {
    tabs.splice(1, 0, {
      id: 'preview',
      name: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepReview.previewTabTitle', {
        defaultMessage: 'Preview'
      }),
      content: /*#__PURE__*/_react.default.createElement(PreviewTab, {
        template: template
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepSummary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "stepTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.stepTitle",
    defaultMessage: "Review details for '{templateName}'",
    values: {
      templateName: name
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), hasWildCardIndexPattern ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.indexPatternsWarningTitle",
      defaultMessage: "This template uses a wildcard (*) as an index pattern."
    }),
    color: "warning",
    iconType: "help",
    "data-test-subj": "indexPatternsWarning"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "indexPatternsWarningDescription"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.indexPatternsWarningDescription",
    defaultMessage: "All new indices that you create will use this template."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: navigateToStep.bind(null, 'logistics')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepReview.summaryTab.indexPatternsWarningLinkText",
    defaultMessage: "Edit index patterns."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "summaryTabContent",
    tabs: tabs
  }));
});
exports.StepReview = StepReview;