"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAsYouType = void 0;
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../../../lib");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultToggleValue = (param, field) => {
  switch (param) {
    case 'similarity':
    case 'term_vector':
    case 'meta':
    case 'max_shingle_size':
      {
        return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
      }
    case 'analyzers':
      {
        return field.search_analyzer !== undefined && field.search_analyzer !== field.analyzer;
      }
    default:
      return false;
  }
};
const SearchAsYouType = /*#__PURE__*/_react.default.memo(({
  field
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.IndexParameter, {
    config: {
      ...(0, _lib.getFieldConfig)('index_options'),
      defaultValue: 'positions'
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.AnalyzersParameter, {
    field: field,
    withSearchQuoteAnalyzer: true
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.MaxShingleSizeParameter, {
    defaultToggleValue: getDefaultToggleValue('max_shingle_size', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.NormsParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.SimilarityParameter, {
    defaultToggleValue: getDefaultToggleValue('similarity', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.TermVectorParameter, {
    field: field,
    defaultToggleValue: getDefaultToggleValue('term_vector', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.StoreParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source)
  })));
});
exports.SearchAsYouType = SearchAsYouType;