"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../../constants");
var _mappings_state_context = require("../../../../mappings_state_context");
var _lib = require("../../../../lib");
var _field_parameters = require("../../field_parameters");
var _field_beta_badge = require("../field_beta_badge");
var _required_parameters_forms = require("./required_parameters_forms");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formWrapper = props => /*#__PURE__*/_react.default.createElement("form", props);
const CreateField = /*#__PURE__*/_react.default.memo(function CreateFieldComponent({
  allFields,
  isRootLevelField,
  isMultiField,
  paddingLeft,
  isCancelable,
  maxNestedDepth
}) {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    serializer: _lib.fieldSerializer,
    options: {
      stripEmptyFields: false
    }
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updatedFieldForm => {
      dispatch({
        type: 'fieldForm.update',
        value: updatedFieldForm
      });
    });
    return subscription.unsubscribe;
  }, [dispatch, subscribe]);
  const cancel = () => {
    dispatch({
      type: 'documentField.changeStatus',
      value: 'idle'
    });
  };
  const submitForm = async (e, exitAfter = false) => {
    if (e) {
      e.preventDefault();
    }
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid) {
      form.reset();
      dispatch({
        type: 'field.add',
        value: data
      });
      if (exitAfter) {
        cancel();
      }
    }
  };
  const onClickOutside = () => {
    const name = form.getFields().name.value;
    if (name.trim() === '') {
      if (isCancelable !== false) {
        cancel();
      }
    } else {
      submitForm(undefined, true);
    }
  };
  const renderFormFields = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_parameters.NameParameter, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_parameters.TypeParameter, {
    isRootLevelField: isRootLevelField,
    isMultiField: isMultiField,
    showDocLink: true
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type"
  }, ({
    type
  }) => {
    if (type === undefined) {
      return null;
    }
    const [fieldType] = type;
    return /*#__PURE__*/_react.default.createElement(_field_parameters.SubTypeParameter, {
      key: fieldType.value,
      type: fieldType.value,
      isMultiField: isMultiField !== null && isMultiField !== void 0 ? isMultiField : false,
      isRootLevelField: isRootLevelField
    });
  }));
  const renderFormActions = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, isCancelable !== false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: cancel,
    "data-test-subj": "cancelButton"
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: submitForm,
    type: "submit",
    "data-test-subj": "addButton"
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.addMultiFieldButtonLabel', {
    defaultMessage: 'Add multi-field'
  }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.addFieldButtonLabel', {
    defaultMessage: 'Add field'
  }))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onClickOutside
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    FormWrapper: formWrapper,
    onSubmit: submitForm,
    "data-test-subj": "createFieldForm"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__createFieldWrapper', {
      'mappingsEditor__createFieldWrapper--toggle': Boolean(maxNestedDepth) && maxNestedDepth > 0,
      'mappingsEditor__createFieldWrapper--multiField': isMultiField
    }),
    style: {
      paddingLeft: `${isMultiField ? paddingLeft - _constants.EUI_SIZE * 1.5 // As there are no "L" bullet list we need to substract some indent
      : paddingLeft}px`
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mappingsEditor__createFieldContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "mappingsEditor__createFieldContent__formFields"
  }, renderFormFields()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderFormActions())), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['type', 'subType']
  }, ({
    type,
    subType
  }) => {
    const RequiredParametersForm = (0, _required_parameters_forms.getRequiredParametersFormForType)(type === null || type === void 0 ? void 0 : type[0].value, subType === null || subType === void 0 ? void 0 : subType[0].value);
    if (!RequiredParametersForm) {
      return null;
    }
    const typeDefinition = _constants.TYPE_DEFINITION[type === null || type === void 0 ? void 0 : type[0].value];
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mappingsEditor__createFieldRequiredProps"
    }, typeDefinition.isBeta ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_beta_badge.FieldBetaBadge, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })) : null, /*#__PURE__*/_react.default.createElement(RequiredParametersForm, {
      key: subType !== null && subType !== void 0 ? subType : type,
      allFields: allFields
    }));
  })))));
});
exports.CreateField = CreateField;