"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _mappings_state_context = require("../../mappings_state_context");
var _lib = require("../../lib");
var _fields = require("./fields");
var _document_fields_header = require("./document_fields_header");
var _fields_json_editor = require("./fields_json_editor");
var _fields_tree_editor = require("./fields_tree_editor");
var _search_fields = require("./search_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const DocumentFields = /*#__PURE__*/_react.default.memo(() => {
  const {
    fields,
    search,
    documentFields
  } = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const {
    editor: editorType
  } = documentFields;
  const isEditing = documentFields.status === 'editingField';
  const jsonEditorDefaultValue = (0, _react.useMemo)(() => {
    if (editorType === 'json') {
      return (0, _lib.deNormalize)(fields);
    }
  }, [editorType, fields]);
  const editor = editorType === 'json' ? /*#__PURE__*/_react.default.createElement(_fields_json_editor.DocumentFieldsJsonEditor, {
    defaultValue: jsonEditorDefaultValue
  }) : /*#__PURE__*/_react.default.createElement(_fields_tree_editor.DocumentFieldsTreeEditor, null);
  const onSearchChange = (0, _react.useCallback)(value => {
    dispatch({
      type: 'search:update',
      value
    });
  }, [dispatch]);
  const exitEdit = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.changeStatus',
      value: 'idle'
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (isEditing) {
      // Open the flyout with the <EditField /> content
      addContentToGlobalFlyout({
        id: 'mappingsEditField',
        Component: _fields.EditFieldContainer,
        props: {
          exitEdit
        },
        flyoutProps: {
          ..._fields.defaultFlyoutProps,
          onClose: exitEdit
        },
        cleanUpFunc: exitEdit
      });
    }
  }, [isEditing, addContentToGlobalFlyout, fields.byId, exitEdit]);
  (0, _react.useEffect)(() => {
    if (!isEditing) {
      removeContentFromGlobalFlyout('mappingsEditField');
    }
  }, [isEditing, removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    return () => {
      if (isEditing) {
        // When the component unmounts, exit edit mode.
        exitEdit();
      }
    };
  }, [isEditing, exitEdit]);
  const searchTerm = search.term.trim();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "documentFields"
  }, /*#__PURE__*/_react.default.createElement(_document_fields_header.DocumentFieldsHeader, {
    searchValue: search.term,
    onSearchChange: onSearchChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), searchTerm !== '' ? /*#__PURE__*/_react.default.createElement(_search_fields.SearchResult, {
    result: search.result,
    documentFieldsState: documentFields
  }) : editor);
});
exports.DocumentFields = DocumentFields;