"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateCreate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _component_templates_context = require("../../component_templates_context");
var _component_template_form = require("../component_template_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplateCreate = ({
  history,
  sourceComponentTemplate
}) => {
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    api,
    breadcrumbs
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const onSave = async componentTemplate => {
    const {
      name
    } = componentTemplate;
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await api.createComponentTemplate(componentTemplate);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }
    history.push({
      pathname: encodeURI(`/component_templates/${encodeURIComponent(name)}`)
    });
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  (0, _react.useEffect)(() => {
    breadcrumbs.setCreateBreadcrumbs();
  }, [breadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createComponentTemplate.pageTitle",
      defaultMessage: "Create component template"
    })),
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_component_template_form.ComponentTemplateForm, {
    defaultValue: sourceComponentTemplate,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError
  }));
};
exports.ComponentTemplateCreate = ComponentTemplateCreate;