"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesAuthProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../shared_imports");
var _component_templates_context = require("../component_templates_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplatesAuthProvider = ({
  children
}) => {
  const {
    httpClient,
    apiBasePath
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  return /*#__PURE__*/_react.default.createElement(_shared_imports.AuthorizationProvider, {
    privilegesEndpoint: `${apiBasePath}/component_templates/privileges`,
    httpClient: httpClient
  }, children);
};
exports.ComponentTemplatesAuthProvider = ComponentTemplatesAuthProvider;