"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFlyoutProps = exports.ComponentTemplateDetailsFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../shared_imports");
var _component_templates_context = require("../component_templates_context");
var _tab_summary = require("./tab_summary");
var _tabs = require("./tabs");
var _manage_button = require("./manage_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFlyoutProps = {
  'data-test-subj': 'componentTemplateDetails',
  'aria-labelledby': 'componentTemplateDetailsFlyoutTitle'
};
exports.defaultFlyoutProps = defaultFlyoutProps;
const ComponentTemplateDetailsFlyoutContent = ({
  componentTemplateName,
  onClose,
  actions,
  showSummaryCallToAction
}) => {
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const decodedComponentTemplateName = (0, _shared_imports.attemptToURIDecode)(componentTemplateName);
  const {
    data: componentTemplateDetails,
    isLoading,
    error
  } = api.useLoadComponentTemplate(decodedComponentTemplateName);
  const [activeTab, setActiveTab] = (0, _react.useState)('summary');
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateDetails.loadingIndexTemplateDescription",
      defaultMessage: "Loading component template\u2026"
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.loadingErrorMessage",
        defaultMessage: "Error loading component template"
      }),
      color: "danger",
      iconType: "warning",
      "data-test-subj": "sectionError"
    }, /*#__PURE__*/_react.default.createElement("p", null, error.message));
  } else if (componentTemplateDetails) {
    const {
      template: {
        settings,
        mappings,
        aliases
      }
    } = componentTemplateDetails;
    const tabToComponentMap = {
      summary: /*#__PURE__*/_react.default.createElement(_tab_summary.TabSummary, {
        componentTemplateDetails: componentTemplateDetails,
        showCallToAction: showSummaryCallToAction
      }),
      settings: /*#__PURE__*/_react.default.createElement(_shared_imports.TabSettings, {
        settings: settings
      }),
      mappings: /*#__PURE__*/_react.default.createElement(_shared_imports.TabMappings, {
        mappings: mappings
      }),
      aliases: /*#__PURE__*/_react.default.createElement(_shared_imports.TabAliases, {
        aliases: aliases
      })
    };
    const tabContent = tabToComponentMap[activeTab];
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tabs.ComponentTemplateTabs, {
      activeTab: activeTab,
      setActiveTab: setActiveTab
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), tabContent);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "componentTemplateDetailsFlyoutTitle",
    "data-test-subj": "title"
  }, decodedComponentTemplateName))), componentTemplateDetails !== null && componentTemplateDetails !== void 0 && componentTemplateDetails._kbnMeta.isManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.managedBadgeLabel",
    defaultMessage: "Managed"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, content), actions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": "footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onClose,
    "data-test-subj": "closeDetailsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.closeButtonLabel",
    defaultMessage: "Close"
  }))), componentTemplateDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_manage_button.ManageButton, {
    actions: actions,
    componentTemplateDetails: componentTemplateDetails
  })))));
};
exports.ComponentTemplateDetailsFlyoutContent = ComponentTemplateDetailsFlyoutContent;