"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormErrorsContext = exports.FormErrorsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormErrorsContext = /*#__PURE__*/(0, _react.createContext)(null);
const createEmptyErrors = () => ({
  hasErrors: false,
  hot: {},
  warm: {},
  cold: {},
  frozen: {},
  delete: {},
  other: {}
});
const FormErrorsProvider = ({
  children
}) => {
  const [errors, setErrors] = (0, _react.useState)(createEmptyErrors);
  const form = (0, _shared_imports.useFormContext)();
  const {
    getErrors: getFormErrors,
    isSubmitted
  } = form;
  const addError = (0, _react.useCallback)((phase, fieldPath, errorMessages) => {
    setErrors(previousErrors => ({
      ...previousErrors,
      hasErrors: true,
      [phase]: {
        ...previousErrors[phase],
        [fieldPath]: errorMessages
      }
    }));
  }, [setErrors]);
  const clearError = (0, _react.useCallback)((phase, fieldPath) => {
    if (getFormErrors().length) {
      setErrors(previousErrors => {
        const {
          [phase]: {
            [fieldPath]: fieldErrorToOmit,
            ...restOfPhaseErrors
          },
          hasErrors,
          ...otherPhases
        } = previousErrors;
        const nextHasErrors = Object.keys(restOfPhaseErrors).length > 0 || Object.values(otherPhases).some(phaseErrors => {
          return Object.keys(phaseErrors).length > 0;
        });
        return {
          ...previousErrors,
          hasErrors: nextHasErrors,
          [phase]: restOfPhaseErrors
        };
      });
    } else {
      setErrors(createEmptyErrors);
    }
  }, [getFormErrors, setErrors]);
  return /*#__PURE__*/_react.default.createElement(FormErrorsContext.Provider, {
    value: {
      errors,
      addError,
      clearError,
      isFormSubmitted: isSubmitted
    }
  }, children);
};
exports.FormErrorsProvider = FormErrorsProvider;
const useFormErrorsContext = () => {
  const ctx = (0, _react.useContext)(FormErrorsContext);
  if (!ctx) {
    throw new Error('useFormErrorsContext can only be used inside of FormErrorsProvider');
  }
  return ctx;
};
exports.useFormErrorsContext = useFormErrorsContext;