"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoTiersAvailableUsingNodeAttributesNotice = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _no_custom_attributes_messages = require("./no_custom_attributes_messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoTiersAvailableUsingNodeAttributesNotice = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "noTiersAvailableUsingNodeAttributesNotice",
    title: _no_custom_attributes_messages.noCustomAttributesTitle,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.indexLifecycleMgmt.dataTier.noTiersAvailableUsingNodeAttributesDescription', {
    defaultMessage: 'Unable to allocate data: no available data nodes.'
  })), /*#__PURE__*/_react.default.createElement("p", null, _no_custom_attributes_messages.nodeAllocationMigrationGuidance));
};
exports.NoTiersAvailableUsingNodeAttributesNotice = NoTiersAvailableUsingNodeAttributesNotice;