"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeAllocationMigrationGuidance = exports.noCustomAttributesTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noCustomAttributesTitle = _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.noCustomAttributesTitle', {
  defaultMessage: 'No custom attributes defined'
});
exports.noCustomAttributesTitle = noCustomAttributesTitle;
const nodeAllocationMigrationGuidance = ({
  docLinks
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.indexLifecycleMgmt.editPolicy.defaultToDataNodesDescription",
  defaultMessage: "To allocate data to particular data nodes, {roleBasedGuidance} or configure custom node attributes in elasticsearch.yml.",
  values: {
    roleBasedGuidance: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.elasticsearch.migrateIndexAllocationFilters,
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.defaultToDataNodesDescription.migrationGuidanceMessage', {
      defaultMessage: 'use role-based allocation'
    }))
  }
});
exports.nodeAllocationMigrationGuidance = nodeAllocationMigrationGuidance;