"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxDocumentCountField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _form = require("../../../../form");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaxDocumentCountField = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: _constants.ROLLOVER_FORM_PATHS.maxDocs,
    component: _shared_imports.NumericField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': `hot-selectedMaxDocuments`,
        min: 1
      }
    }
  })));
};
exports.MaxDocumentCountField = MaxDocumentCountField;