"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nLoader = exports.i18n = void 0;
var _core = require("./src/core");
var _loader = require("./src/loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const i18n = {
  formats: _core.formats,
  addTranslation: _core.addTranslation,
  getTranslation: _core.getTranslation,
  setLocale: _core.setLocale,
  getLocale: _core.getLocale,
  setDefaultLocale: _core.setDefaultLocale,
  getDefaultLocale: _core.getDefaultLocale,
  setFormats: _core.setFormats,
  getFormats: _core.getFormats,
  getRegisteredLocales: _core.getRegisteredLocales,
  translate: _core.translate,
  init: _core.init,
  load: _core.load,
  isPseudoLocale: _core.isPseudoLocale,
  translateUsingPseudoLocale: _core.translateUsingPseudoLocale
};
exports.i18n = i18n;
const i18nLoader = {
  registerTranslationFile: _loader.registerTranslationFile,
  registerTranslationFiles: _loader.registerTranslationFiles,
  getTranslationsByLocale: _loader.getTranslationsByLocale,
  getAllTranslations: _loader.getAllTranslations,
  getAllTranslationsFromPaths: _loader.getAllTranslationsFromPaths,
  getRegisteredLocales: _loader.getRegisteredLocales
};
exports.i18nLoader = i18nLoader;