"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StringParameter = StringParameter;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function StringParameter({
  id,
  label,
  value,
  setParameter
}) {
  const handleChange = evt => {
    setParameter(id, evt.target.value);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditorSidebar__formRow"
  }, /*#__PURE__*/_react.default.createElement("label", {
    className: "visEditorSidebar__formLabel"
  }, label), /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditorSidebar__formControl kuiFieldGroupSection--wide"
  }, /*#__PURE__*/_react.default.createElement("input", {
    className: "kuiTextInput",
    type: "text",
    value: value,
    onChange: handleChange
  })));
}
StringParameter.propTypes = {
  id: _propTypes.default.string.isRequired,
  label: _propTypes.default.string.isRequired,
  value: _propTypes.default.string.isRequired,
  setParameter: _propTypes.default.func.isRequired
};