"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStarted = void 0;
var _react = _interopRequireWildcard(require("react"));
var _queryString = require("query-string");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _guidedOnboarding = require("@kbn/guided-onboarding");
var _kibana_services = require("../../kibana_services");
var _home = require("../home");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const homeBreadcrumb = _i18n.i18n.translate('home.breadcrumbs.homeTitle', {
  defaultMessage: 'Home'
});
const gettingStartedBreadcrumb = _i18n.i18n.translate('home.breadcrumbs.gettingStartedTitle', {
  defaultMessage: 'Setup guides'
});
const title = _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.useCaseSelectionTitle', {
  defaultMessage: 'What would you like to do first?'
});
const subtitle = _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.useCaseSelectionSubtitle', {
  defaultMessage: `Select a guide to help you make the most of your data.`
});
const skipText = _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.skip.buttonLabel', {
  defaultMessage: `I’d like to explore on my own.`
});
const GettingStarted = () => {
  const {
    application,
    trackUiMetric,
    chrome,
    guidedOnboardingService,
    cloud,
    cloudChat
  } = (0, _kibana_services.getServices)();
  const [guidesState, setGuidesState] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [isError, setIsError] = (0, _react.useState)(false);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const query = (0, _queryString.parse)(search);
  const isTypeOfGuideFilterValue = useCase => {
    const filterValues = ['search', 'observability', 'security', 'all']; // list of GuideFilterValues types

    if (!useCase) {
      return false;
    }
    if (useCase instanceof Array) {
      return filterValues.includes(useCase[0]);
    }
    return filterValues.includes(useCase);
  };
  const [filter, setFilter] = (0, _react.useState)(isTypeOfGuideFilterValue(query.useCase) ? query.useCase : 'all');
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    chrome.setBreadcrumbs([{
      // using # prevents a reloading of the whole app when clicking the breadcrumb
      href: '#',
      text: homeBreadcrumb,
      onClick: () => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'guided_onboarding__home_breadcrumb');
      }
    }, {
      text: gettingStartedBreadcrumb
    }]);
  }, [chrome, trackUiMetric]);
  const fetchGuidesState = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    setIsError(false);
    try {
      const allGuides = await (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.fetchAllGuidesState());
      setIsLoading(false);
      if (allGuides) {
        setGuidesState(allGuides.state);
      }
    } catch (error) {
      setIsLoading(false);
      setIsError(true);
    }
  }, [guidedOnboardingService]);
  (0, _react.useEffect)(() => {
    fetchGuidesState();
  }, [fetchGuidesState]);
  (0, _react.useEffect)(() => {
    if ((cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) === false) {
      return history.push('/');
    }
  }, [cloud, history]);
  (0, _react.useEffect)(() => {
    // disable welcome screen on the home page
    localStorage.setItem(_home.KEY_ENABLE_WELCOME, JSON.stringify(false));
  }, []);
  const onSkip = async () => {
    try {
      await (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.skipGuidedOnboarding());
    } catch (error) {
      // if the state update fails, it's safe to ignore the error
    }
    trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'guided_onboarding__skipped');
    application.navigateToApp('home');
  };
  const activateGuide = (0, _react.useCallback)(async (guideId, guideState) => {
    try {
      await (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.activateGuide(guideId, guideState));
    } catch (err) {
      (0, _kibana_services.getServices)().toastNotifications.addDanger({
        title: _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.activateGuide.errorMessage', {
          defaultMessage: 'Unable to start the guide. Wait a moment and try again.'
        }),
        text: err.message
      });
    }
  }, [guidedOnboardingService]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      }),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.loadingIndicator', {
        defaultMessage: 'Loading the guide state...'
      })),
      "data-test-subj": "onboarding--loadingIndicator"
    });
  }
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.errorSectionTitle', {
        defaultMessage: 'Unable to load the guide state'
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.errorSectionDescription', {
        defaultMessage: `The guide couldn't be loaded. Wait a moment and try again.`
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: fetchGuidesState,
        iconType: "refresh",
        color: "danger"
      }, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.errorSectionRefreshButton', {
        defaultMessage: 'Refresh'
      }))),
      "data-test-subj": "onboarding--errorSection"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    panelled: false,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "center",
    "data-test-subj": "guided-onboarding--landing-page"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement("h1", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, subtitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_guidedOnboarding.GuideFilters, {
    application: application,
    activeFilter: filter,
    setActiveFilter: setFilter,
    "data-test-subj": "onboarding--guideFilters"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_guidedOnboarding.GuideCards, {
    activateGuide: activateGuide,
    navigateToApp: application.navigateToApp,
    activeFilter: filter,
    guidesState: guidesState
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onSkip,
    "data-test-subj": "onboarding--skipGuideLink"
  }, skipText)), (cloudChat === null || cloudChat === void 0 ? void 0 : cloudChat.Chat) && /*#__PURE__*/_react.default.createElement(cloudChat.Chat, null)));
};
exports.GettingStarted = GettingStarted;