"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcePicker = SourcePicker;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/saved-objects-finder-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fixedPageSize = 8;
function SourcePicker({
  http,
  uiSettings,
  savedObjectsManagement,
  onIndexPatternSelected
}) {
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    services: {
      http,
      uiSettings,
      savedObjectsManagement
    },
    onChoose: (_id, _type, _name, indexPattern) => {
      onIndexPatternSelected(indexPattern);
    },
    showFilter: false,
    noItemsMessage: _i18n.i18n.translate('xpack.graph.sourceModal.notFoundLabel', {
      defaultMessage: 'No data sources found.'
    }),
    savedObjectMetaData: [{
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.graph.sourceModal.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      }),
      showSavedObject: indexPattern => !indexPattern.attributes.type,
      includeFields: ['type'],
      defaultSearchField: 'name'
    }],
    fixedPageSize: fixedPageSize
  });
}