"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlPanelToolBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ControlPanelToolBar = ({
  workspace,
  onSetControl,
  liveResponseFields
}) => {
  const haveNodes = workspace.nodes.length === 0;
  const undoButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.undoButtonTooltip', {
    defaultMessage: 'Undo'
  });
  const redoButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.redoButtonTooltip', {
    defaultMessage: 'Redo'
  });
  const expandButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.expandSelectionButtonTooltip', {
    defaultMessage: 'Expand selection'
  });
  const addLinksButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.addLinksButtonTooltip', {
    defaultMessage: 'Add links between existing terms'
  });
  const removeVerticesButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.removeVerticesButtonTooltip', {
    defaultMessage: 'Remove vertices from workspace'
  });
  const blocklistButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.blocklistButtonTooltip', {
    defaultMessage: 'Block selection from appearing in workspace'
  });
  const customStyleButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.customStyleButtonTooltip', {
    defaultMessage: 'Custom style selected vertices'
  });
  const drillDownButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.drillDownButtonTooltip', {
    defaultMessage: 'Drill down'
  });
  const runLayoutButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.runLayoutButtonTooltip', {
    defaultMessage: 'Run layout'
  });
  const pauseLayoutButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.topMenu.pauseLayoutButtonTooltip', {
    defaultMessage: 'Pause layout'
  });
  const onUndoClick = () => workspace.undo();
  const onRedoClick = () => workspace.redo();
  const onExpandButtonClick = () => {
    onSetControl('none');
    workspace.expandSelecteds({
      toFields: liveResponseFields
    });
  };
  const onAddLinksClick = () => workspace.fillInGraph();
  const onRemoveVerticesClick = () => {
    onSetControl('none');
    workspace.deleteSelection();
  };
  const onBlockListClick = () => workspace.blocklistSelection();
  const onCustomStyleClick = () => onSetControl('style');
  const onDrillDownClick = () => onSetControl('drillDowns');
  const onRunLayoutClick = () => workspace.runLayout();
  const onPauseLayoutClick = () => {
    workspace.stopLayout();
    workspace.changeHandler();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: undoButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    "aria-label": undoButtonMsg,
    type: "button",
    onClick: onUndoClick,
    disabled: workspace.undoLog.length < 1
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-history"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: redoButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    "aria-label": redoButtonMsg,
    type: "button",
    onClick: onRedoClick,
    disabled: workspace.redoLog.length === 0
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-repeat"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: expandButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    "aria-label": expandButtonMsg,
    disabled: liveResponseFields.length === 0 || workspace.nodes.length === 0,
    onClick: onExpandButtonClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-plus"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: addLinksButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    "aria-label": addLinksButtonMsg,
    disabled: haveNodes,
    onClick: onAddLinksClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-link"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: removeVerticesButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": "graphRemoveSelection",
    className: "kuiButton kuiButton--basic kuiButton--small",
    disabled: haveNodes,
    "aria-label": removeVerticesButtonMsg,
    onClick: onRemoveVerticesClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-trash"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: blocklistButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    disabled: workspace.selectedNodes.length === 0,
    "aria-label": blocklistButtonMsg,
    onClick: onBlockListClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-ban"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: customStyleButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    disabled: workspace.selectedNodes.length === 0,
    "aria-label": customStyleButtonMsg,
    onClick: onCustomStyleClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-paint-brush"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: drillDownButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kuiButton kuiButton--basic kuiButton--small",
    disabled: haveNodes,
    "aria-label": drillDownButtonMsg,
    onClick: onDrillDownClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-info"
  })))), (workspace.nodes.length === 0 || workspace.force === null) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: runLayoutButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": "graphResumeLayout",
    className: "kuiButton kuiButton--basic kuiButton--small",
    disabled: workspace.nodes.length === 0,
    "aria-label": runLayoutButtonMsg,
    onClick: onRunLayoutClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-play"
  })))), workspace.force !== null && workspace.nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: pauseLayoutButtonMsg
  }, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": "graphPauseLayout",
    className: "kuiButton kuiButton--basic kuiButton--small",
    "aria-label": pauseLayoutButtonMsg,
    onClick: onPauseLayoutClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-pause"
  })))));
};
exports.ControlPanelToolBar = ControlPanelToolBar;