"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _security = require("../../services/security");
var _constants = require("../../constants");
var _types = require("../../types");
var _security2 = require("../../services/security/security");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // List
  router.get({
    path: _constants.PACKAGE_POLICY_API_ROUTES.LIST_PATTERN,
    validate: _types.GetPackagePoliciesRequestSchema,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants.PACKAGE_POLICY_API_ROUTES.LIST_PATTERN)).granted
  }, _handlers.getPackagePoliciesHandler);

  // Get bulk
  router.post({
    path: _constants.PACKAGE_POLICY_API_ROUTES.BULK_GET_PATTERN,
    validate: _types.BulkGetPackagePoliciesRequestSchema,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('post', _constants.PACKAGE_POLICY_API_ROUTES.BULK_GET_PATTERN)).granted
  }, _handlers.bulkGetPackagePoliciesHandler);

  // Get one
  router.get({
    path: _constants.PACKAGE_POLICY_API_ROUTES.INFO_PATTERN,
    validate: _types.GetOnePackagePolicyRequestSchema,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants.PACKAGE_POLICY_API_ROUTES.INFO_PATTERN)).granted
  }, _handlers.getOnePackagePolicyHandler);
  router.get({
    path: _constants.PACKAGE_POLICY_API_ROUTES.ORPHANED_INTEGRATION_POLICIES,
    validate: {},
    fleetAuthz: {
      integrations: {
        readIntegrationPolicies: true
      }
    }
  }, _handlers.getOrphanedPackagePolicies);

  // Create
  router.post({
    path: _constants.PACKAGE_POLICY_API_ROUTES.CREATE_PATTERN,
    validate: _types.CreatePackagePolicyRequestSchema
  }, _handlers.createPackagePolicyHandler);

  // Update
  router.put({
    path: _constants.PACKAGE_POLICY_API_ROUTES.UPDATE_PATTERN,
    validate: _types.UpdatePackagePolicyRequestSchema,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('put', _constants.PACKAGE_POLICY_API_ROUTES.UPDATE_PATTERN)).granted
  }, _handlers.updatePackagePolicyHandler);

  // Delete (bulk)
  router.post({
    path: _constants.PACKAGE_POLICY_API_ROUTES.DELETE_PATTERN,
    validate: _types.DeletePackagePoliciesRequestSchema,
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    }
  }, _handlers.deletePackagePolicyHandler);
  router.delete({
    path: _constants.PACKAGE_POLICY_API_ROUTES.INFO_PATTERN,
    validate: _types.DeleteOnePackagePolicyRequestSchema,
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    }
  }, _handlers.deleteOnePackagePolicyHandler);

  // Upgrade
  router.post({
    path: _constants.PACKAGE_POLICY_API_ROUTES.UPGRADE_PATTERN,
    validate: _types.UpgradePackagePoliciesRequestSchema,
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    }
  }, _handlers.upgradePackagePolicyHandler);

  // Upgrade - DryRun
  router.post({
    path: _constants.PACKAGE_POLICY_API_ROUTES.DRYRUN_PATTERN,
    validate: _types.DryRunPackagePoliciesRequestSchema,
    fleetAuthz: {
      integrations: {
        readIntegrationPolicies: true
      }
    }
  }, _handlers.dryRunUpgradePackagePolicyHandler);
};
exports.registerRoutes = registerRoutes;