"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudFormationTemplateUrlFromAgentPolicy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the cloud formation template url from a agent policy
 * It looks for a config with a cloud_formation_template_url object present in
 * the enabled package_policies inputs of the agent policy
 */
const getCloudFormationTemplateUrlFromAgentPolicy = selectedPolicy => {
  var _selectedPolicy$packa;
  const cloudFormationTemplateUrl = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : (_selectedPolicy$packa = selectedPolicy.package_policies) === null || _selectedPolicy$packa === void 0 ? void 0 : _selectedPolicy$packa.reduce((acc, packagePolicy) => {
    var _packagePolicy$inputs;
    const findCloudFormationTemplateUrlConfig = (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.reduce((accInput, input) => {
      var _input$config;
      if (accInput !== '') {
        return accInput;
      }
      if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$config = input.config) !== null && _input$config !== void 0 && _input$config.cloud_formation_template_url) {
        return input.config.cloud_formation_template_url.value;
      }
      return accInput;
    }, '');
    if (findCloudFormationTemplateUrlConfig) {
      return findCloudFormationTemplateUrlConfig;
    }
    return acc;
  }, '');
  return cloudFormationTemplateUrl !== '' ? cloudFormationTemplateUrl : undefined;
};
exports.getCloudFormationTemplateUrlFromAgentPolicy = getCloudFormationTemplateUrlFromAgentPolicy;