"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUninstallTokens = void 0;
var _services = require("../../../common/services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetUninstallTokens = ({
  policyId,
  page,
  perPage
} = {}) => {
  const query = {
    policyId,
    page,
    perPage
  };
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.uninstallTokensRouteService.getListPath(),
    query
  });
};
exports.useGetUninstallTokens = useGetUninstallTokens;