"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGetSettings = sendGetSettings;
exports.sendPutSettings = sendPutSettings;
exports.useGetSettings = useGetSettings;
exports.useGetSettingsQuery = useGetSettingsQuery;
var _reactQuery = require("@tanstack/react-query");
var _services = require("../../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetSettingsQuery() {
  return (0, _reactQuery.useQuery)(['settings'], () => (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: _services.settingsRoutesService.getInfoPath()
  }));
}
function useGetSettings() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.settingsRoutesService.getInfoPath()
  });
}
function sendGetSettings() {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.settingsRoutesService.getInfoPath()
  });
}
function sendPutSettings(body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.settingsRoutesService.getUpdatePath(),
    body
  });
}