"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallCommandFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _uninstall_tokens = require("../../hooks/use_request/uninstall_tokens");
var _error = require("../error");
var _loading = require("../loading");
var _uninstall_commands_per_platform = require("./uninstall_commands_per_platform");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UninstallAgentDescription = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.firstParagraph",
    defaultMessage: "Uninstall Elastic Agent and unenroll in Fleet to stop communicating with the host."
  })), /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.subtitle",
    defaultMessage: "Uninstall Elastic Agent on your host"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.description",
    defaultMessage: "Select the appropriate platform and run the command to uninstall Elastic Agent. Reuse the command to uninstall agents on more than one host. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.uninstallAgent,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.learnMore', {
        defaultMessage: 'Learn more'
      }))
    }
  })));
};
const UninstallEndpointDescription = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.endpointUninstallCommandFlyout.subtitle",
  defaultMessage: "Uninstall Elastic Defend integration on your host"
})), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.endpointUninstallCommandFlyout.description",
  defaultMessage: "Use the below uninstall command to uninstall Endpoint integration... [TODO]"
})));
const UninstallCommands = ({
  policyId
}) => {
  var _data$items$0$token, _data$items, _data$items$;
  const {
    data,
    error,
    isLoading
  } = (0, _uninstall_tokens.useGetUninstallTokens)({
    policyId
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      size: "l"
    });
  }
  const token = (_data$items$0$token = data === null || data === void 0 ? void 0 : (_data$items = data.items) === null || _data$items === void 0 ? void 0 : (_data$items$ = _data$items[0]) === null || _data$items$ === void 0 ? void 0 : _data$items$.token) !== null && _data$items$0$token !== void 0 ? _data$items$0$token : null;
  if (error || !token) {
    return /*#__PURE__*/_react.default.createElement(_error.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentUninstallCommandFlyout.errorFetchingToken",
        defaultMessage: "Unable to fetch uninstall token"
      }),
      error: error !== null && error !== void 0 ? error : _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.unknownError', {
        defaultMessage: 'Unknown error'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_uninstall_commands_per_platform.UninstallCommandsPerPlatform, {
    token: token
  });
};
const UninstallCommandFlyout = ({
  policyId,
  onClose,
  target
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "uninstall-command-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.title",
    defaultMessage: "Uninstall agent"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, target === 'agent' ? /*#__PURE__*/_react.default.createElement(UninstallAgentDescription, null) : /*#__PURE__*/_react.default.createElement(UninstallEndpointDescription, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(UninstallCommands, {
    policyId: policyId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "uninstall-command-flyout-policy-id-hint"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.validForPolicyId",
    defaultMessage: "Valid for the following agent policy:"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, policyId))));
};
exports.UninstallCommandFlyout = UninstallCommandFlyout;