"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudFormationGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_FORMATION_EXTERNAL_DOC_URL = 'https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-howdoesitwork.html';
const Link = ({
  children,
  url
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: url,
  target: "_blank",
  rel: "noopener nofollow noreferrer",
  "data-test-subj": "externalLink"
}, children);
const CloudFormationGuide = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.cloudFormation.guide.description",
    defaultMessage: "CloudFormation will create all the necessary resources to evaluate the security posture of your AWS environment. {learnMore}.",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(Link, {
        url: CLOUD_FORMATION_EXTERNAL_DOC_URL
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.cloudFormation.guide.learnMoreLinkText",
        defaultMessage: "Learn more about CloudFormation"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("ol", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.cloudFormation.guide.steps.login",
    defaultMessage: "Ensure you are logged in as an admin in the AWS Account you want to onboard"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.cloudFormation.guide.steps.launch",
    defaultMessage: "Click the Launch CloudFormation button below."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.cloudFormation.guide.steps.region",
    defaultMessage: "(Optional) Change the Amazon region in the upper right corner to the region you want to deploy your stack to"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.cloudFormation.guide.steps.accept",
    defaultMessage: "Tick the checkbox under capabilities in the opened CloudFormation stack review form: {acknowledge}",
    values: {
      acknowledge: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.cloudFormation.guide.steps.accept.acknowledge",
        defaultMessage: "I acknowledge that AWS CloudFormation might create IAM resources."
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.cloudFormation.guide.steps.create",
    defaultMessage: "Click Create stack."
  })))));
};
exports.CloudFormationGuide = CloudFormationGuide;