"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyPackageBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyPackageBadge = ({
  excludeFleetServer,
  pkgName,
  pkgVersion,
  pkgTitle
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    isDisabled: excludeFleetServer && pkgName === _constants.FLEET_SERVER_PACKAGE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_.PackageIcon, {
    packageName: pkgName,
    version: pkgVersion || '',
    tryApi: pkgVersion !== undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, pkgTitle)));
};
exports.AgentPolicyPackageBadge = AgentPolicyPackageBadge;