"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToCard = exports.getParams = exports.categoryExists = exports.EPMHomePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _has_deferred_installations = require("../../../../../../services/has_deferred_installations");
var _services = require("../../../../../../../common/services");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../constants");
var _layouts = require("../../../../layouts");
var _services2 = require("../../../../services");
var _hooks = require("../../../../hooks");
var _installed_packages = require("./installed_packages");
var _available_packages = require("./available_packages");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParams = (params, search) => {
  const {
    category,
    subcategory
  } = params;
  const selectedCategory = category || '';
  const queryParams = new URLSearchParams(search);
  const searchParam = queryParams.get(_constants2.INTEGRATIONS_SEARCH_QUERYPARAM) || '';
  return {
    selectedCategory,
    searchParam,
    selectedSubcategory: subcategory
  };
};
exports.getParams = getParams;
const categoryExists = (category, categories) => {
  return categories.some(c => c.id === category);
};
exports.categoryExists = categoryExists;
const mapToCard = ({
  getAbsolutePath,
  getHref,
  item,
  addBasePath,
  packageVerificationKeyId,
  selectedCategory
}) => {
  let uiInternalPathUrl;
  let isUnverified = false;
  const version = 'version' in item ? item.version || '' : '';
  let isUpdateAvailable = false;
  let isReauthorizationRequired = false;
  if (item.type === 'ui_link') {
    uiInternalPathUrl = item.id.includes('language_client.') ? addBasePath(item.uiInternalPath) : item.uiExternalLink || getAbsolutePath(item.uiInternalPath);
  } else {
    var _item$installationInf;
    let urlVersion = item.version;
    if (item !== null && item !== void 0 && (_item$installationInf = item.installationInfo) !== null && _item$installationInf !== void 0 && _item$installationInf.version) {
      urlVersion = item.installationInfo.version || item.version;
      isUnverified = (0, _services2.isPackageUnverified)(item, packageVerificationKeyId);
      isUpdateAvailable = (0, _services2.isPackageUpdatable)(item);
      isReauthorizationRequired = (0, _has_deferred_installations.hasDeferredInstallations)(item);
    }
    const url = getHref('integration_details_overview', {
      pkgkey: `${item.name}-${urlVersion}`,
      ...(item.integration ? {
        integration: item.integration
      } : {})
    });
    uiInternalPathUrl = url;
  }
  const release = (0, _services.getPackageReleaseLabel)(version);
  return {
    id: `${item.type === 'ui_link' ? 'ui_link' : 'epr'}:${item.id}`,
    description: item.description,
    icons: !item.icons || !item.icons.length ? [] : item.icons,
    title: item.title,
    url: uiInternalPathUrl,
    fromIntegrations: selectedCategory,
    integration: 'integration' in item ? item.integration || '' : '',
    name: 'name' in item ? item.name : item.id,
    version,
    release,
    categories: (item.categories || []).filter(c => !!c),
    isReauthorizationRequired,
    isUnverified,
    isUpdateAvailable
  };
};
exports.mapToCard = mapToCard;
const EPMHomePage = () => {
  const [prereleaseEnabled, setPrereleaseEnabled] = (0, _react.useState)(false);

  // loading packages to find installed ones
  const {
    data: allPackages,
    isLoading
  } = (0, _hooks.useGetPackagesQuery)({
    prerelease: prereleaseEnabled
  });
  const installedPackages = ((allPackages === null || allPackages === void 0 ? void 0 : allPackages.items) || []).filter(pkg => pkg.status === _constants.installationStatuses.Installed);
  const unverifiedPackageCount = installedPackages.filter(pkg => {
    var _pkg$installationInfo;
    return ((_pkg$installationInfo = pkg.installationInfo) === null || _pkg$installationInfo === void 0 ? void 0 : _pkg$installationInfo.verification_status) && pkg.installationInfo.verification_status === 'unverified';
  }).length;
  const upgradeablePackageCount = installedPackages.filter(_services2.isPackageUpdatable).length;
  const notificationsBySection = {
    manage: unverifiedPackageCount + upgradeablePackageCount
  };
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integrations_installed
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "manage",
    notificationsBySection: notificationsBySection
  }, /*#__PURE__*/_react.default.createElement(_installed_packages.InstalledPackages, {
    installedPackages: installedPackages,
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integrations_all
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "browse",
    notificationsBySection: notificationsBySection
  }, /*#__PURE__*/_react.default.createElement(_available_packages.AvailablePackages, {
    setPrereleaseEnabled: setPrereleaseEnabled
  }))));
};
exports.EPMHomePage = EPMHomePage;