"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALL_INSTALLED_CATEGORY = exports.ALL_CATEGORY = void 0;
exports.CategoryFacets = CategoryFacets;
exports.UPDATES_AVAILABLE_CATEGORY = exports.UPDATES_AVAILABLE = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _components = require("../../../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATES_AVAILABLE = 'updates_available';
exports.UPDATES_AVAILABLE = UPDATES_AVAILABLE;
const ALL_CATEGORY = {
  id: '',
  title: _i18n.i18n.translate('xpack.fleet.epmList.allPackagesFilterLinkText', {
    defaultMessage: 'All categories'
  })
};
exports.ALL_CATEGORY = ALL_CATEGORY;
const ALL_INSTALLED_CATEGORY = {
  id: '',
  title: _i18n.i18n.translate('xpack.fleet.epmList.allPackagesInstalledFilterLinkText', {
    defaultMessage: 'All installed'
  })
};
exports.ALL_INSTALLED_CATEGORY = ALL_INSTALLED_CATEGORY;
const UPDATES_AVAILABLE_CATEGORY = {
  id: UPDATES_AVAILABLE,
  title: _i18n.i18n.translate('xpack.fleet.epmList.updatesAvailableFilterLinkText', {
    defaultMessage: 'Updates available'
  })
};
exports.UPDATES_AVAILABLE_CATEGORY = UPDATES_AVAILABLE_CATEGORY;
function CategoryFacets({
  isLoading,
  categories,
  selectedCategory,
  onCategoryChange
}) {
  const controls = /*#__PURE__*/_react.default.createElement(_eui.EuiFacetGroup, null, isLoading ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : categories.map(category => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
      "data-test-subj": `epmList.categories.${category.id}`,
      isSelected: category.id === selectedCategory,
      key: category.id,
      id: category.id,
      quantity: category.count,
      onClick: () => onCategoryChange(category)
    }, category.title);
  }));
  return controls;
}