"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFirstTimeAgentUserQuery = void 0;
var _hooks = require("../../../../../hooks");
var _services = require("../../../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsFirstTimeAgentUserQuery = () => {
  var _agents$data;
  const {
    data: agentPolicies,
    isLoading: areAgentPoliciesLoading,
    isFetched: areAgentsFetched
  } = (0, _hooks.useGetAgentPoliciesQuery)({
    full: true
  });

  // now get all agents that are NOT part of a fleet server policy
  const serverPolicyIdsQuery = ((agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.items) || []).filter(item => (0, _services.policyHasFleetServer)(item)).map(p => `policy_id:${p.id}`).join(' or ');

  // get agents that are not unenrolled and not fleet server
  const kuery = `not (_exists_:"unenrolled_at")` + (serverPolicyIdsQuery.length ? ` and not (${serverPolicyIdsQuery})` : '');
  const {
    data: agents,
    isLoading: areAgentsLoading
  } = (0, _hooks.useGetAgentsQuery)({
    page: 1,
    perPage: 1,
    // we only need to know if there is at least one non-fleet agent
    showInactive: true,
    kuery
  }, {
    enabled: areAgentsFetched
  } // don't run the query until agent policies are loaded
  );

  return {
    isLoading: areAgentPoliciesLoading || areAgentsLoading,
    isFirstTimeAgentUser: (agents === null || agents === void 0 ? void 0 : (_agents$data = agents.data) === null || _agents$data === void 0 ? void 0 : _agents$data.total) === 0
  };
};
exports.useIsFirstTimeAgentUserQuery = useIsFirstTimeAgentUserQuery;