"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfirmOpenUnverified = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_core = require("../../../hooks/use_core");
var _confirm_open_unverified_modal = require("../components/confirm_open_unverified_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Direct imports are important here, importing all hooks breaks unit tests
// and increases bundle size because this is imported on first page load

const confirmOpenUnverified = ({
  pkgName,
  overlays,
  docLinks
}) => new Promise(resolve => {
  const session = overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_confirm_open_unverified_modal.ConfirmOpenUnverifiedModal, {
    pkgName: pkgName,
    onConfirm: () => {
      session.close();
      resolve(true);
    },
    onCancel: () => {
      session.close();
      resolve(false);
    },
    docLinks: docLinks
  })));
});
const useConfirmOpenUnverified = () => {
  const {
    overlays,
    docLinks
  } = (0, _use_core.useStartServices)();
  return (0, _react.useCallback)(pkgName => confirmOpenUnverified({
    pkgName,
    overlays,
    docLinks
  }), [docLinks, overlays]);
};
exports.useConfirmOpenUnverified = useConfirmOpenUnverified;