"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeploymentDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Description = (0, _styledComponents.default)(_eui.EuiText)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeL};
`;
const DeploymentDetails = ({
  cloudId,
  learnMoreUrl,
  managementUrl
}) => {
  const [isOpen, setIsOpen] = _react.default.useState(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    onClick: () => setIsOpen(!isOpen),
    iconType: "iInCircle",
    iconSide: "left",
    isActive: true
  }, _i18n.i18n.translate('xpack.fleet.integrations.deploymentButton', {
    defaultMessage: 'View deployment details'
  }));
  const management = managementUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "API keys",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: managementUrl
  }, "Create and manage API keys")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: learnMoreUrl,
    target: "_blank"
  }, "Learn more")))) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    button: button,
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 450
    }
  }, /*#__PURE__*/_react.default.createElement(Description, null, _i18n.i18n.translate('xpack.fleet.integrations.deploymentDescription', {
    defaultMessage: 'Send data to Elastic from your applications by referencing your deployment.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Cloud ID",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: cloudId,
    fullWidth: true,
    disabled: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: cloudId
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    display: "base",
    size: "m"
  }))))), management)));
};
exports.DeploymentDetails = DeploymentDetails;