"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOutputForm = useOutputForm;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _jsYaml = require("js-yaml");
var _hooks = require("../../../../hooks");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _services = require("../../../../services");
var _output_form_validators = require("./output_form_validators");
var _confirm_update = require("./confirm_update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUEUE_MAX_SIZE = 4096;
function useOutputForm(onSucess, output) {
  var _fleetStatus$missingO, _output$is_preconfigu, _output$allow_edit, _output$name, _output$type, _output$config_yaml, _output$is_default, _output$is_default_mo, _output$ca_trusted_fi, _output$hosts, _configJs$shipper, _output$shipper$disk_, _output$shipper, _output$shipper$disk_2, _output$shipper2, _diskQueueEnabledInpu, _output$shipper$disk_3, _output$shipper3, _diskQueueEnabledInpu2, _output$shipper$disk_4, _output$shipper4, _diskQueueEnabledInpu3, _output$shipper$disk_5, _output$shipper5, _output$shipper$disk_6, _output$shipper6, _ref, _output$shipper7, _diskQueueCompression, _output$shipper8, _output$shipper9, _output$shipper10, _output$hosts2, _output$ssl$certifica, _output$ssl, _output$ssl$certifica2, _output$ssl2, _output$ssl$key, _output$ssl3, _output$proxy_id;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    showExperimentalShipperOptions
  } = _services.ExperimentalFeaturesService.get();
  const hasEncryptedSavedObjectConfigured = !((_fleetStatus$missingO = fleetStatus.missingOptionalFeatures) !== null && _fleetStatus$missingO !== void 0 && _fleetStatus$missingO.includes('encrypted_saved_object_encryption_key_required'));
  const [isLoading, setIsloading] = (0, _react.useState)(false);
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();

  // preconfigured output do not allow edition
  const isPreconfigured = (_output$is_preconfigu = output === null || output === void 0 ? void 0 : output.is_preconfigured) !== null && _output$is_preconfigu !== void 0 ? _output$is_preconfigu : false;
  const allowEdit = (_output$allow_edit = output === null || output === void 0 ? void 0 : output.allow_edit) !== null && _output$allow_edit !== void 0 ? _output$allow_edit : [];
  function isDisabled(field) {
    if (!isPreconfigured) {
      return false;
    }
    return !allowEdit.includes(field);
  }

  // Define inputs
  // Shared inputs
  const nameInput = (0, _hooks.useInput)((_output$name = output === null || output === void 0 ? void 0 : output.name) !== null && _output$name !== void 0 ? _output$name : '', _output_form_validators.validateName, isDisabled('name'));
  const typeInput = (0, _hooks.useInput)((_output$type = output === null || output === void 0 ? void 0 : output.type) !== null && _output$type !== void 0 ? _output$type : 'elasticsearch', undefined, isDisabled('type'));
  const additionalYamlConfigInput = (0, _hooks.useInput)((_output$config_yaml = output === null || output === void 0 ? void 0 : output.config_yaml) !== null && _output$config_yaml !== void 0 ? _output$config_yaml : '', _output_form_validators.validateYamlConfig, isDisabled('config_yaml'));
  const defaultOutputInput = (0, _hooks.useSwitchInput)((_output$is_default = output === null || output === void 0 ? void 0 : output.is_default) !== null && _output$is_default !== void 0 ? _output$is_default : false, isDisabled('is_default') || (output === null || output === void 0 ? void 0 : output.is_default));
  const defaultMonitoringOutputInput = (0, _hooks.useSwitchInput)((_output$is_default_mo = output === null || output === void 0 ? void 0 : output.is_default_monitoring) !== null && _output$is_default_mo !== void 0 ? _output$is_default_mo : false, isDisabled('is_default_monitoring') || (output === null || output === void 0 ? void 0 : output.is_default_monitoring));

  // ES inputs
  const caTrustedFingerprintInput = (0, _hooks.useInput)((_output$ca_trusted_fi = output === null || output === void 0 ? void 0 : output.ca_trusted_fingerprint) !== null && _output$ca_trusted_fi !== void 0 ? _output$ca_trusted_fi : '', _output_form_validators.validateCATrustedFingerPrint, isDisabled('ca_trusted_fingerprint'));
  const elasticsearchUrlInput = (0, _hooks.useComboInput)('esHostsComboxBox', (_output$hosts = output === null || output === void 0 ? void 0 : output.hosts) !== null && _output$hosts !== void 0 ? _output$hosts : [], _output_form_validators.validateESHosts, isDisabled('hosts'));
  /*
  Shipper feature flag - currently depends on the content of the yaml
  # Enables the shipper:
  shipper: {}
   # Also enables the shipper:
  shipper:
    enabled: true
   # Yet another way of enabling it:
  shipper:
    queue:
      ...
   # Disables the shipper
  shipper:
    enabled: false
  */
  const configJs = output !== null && output !== void 0 && output.config_yaml ? (0, _jsYaml.safeLoad)(output === null || output === void 0 ? void 0 : output.config_yaml) : {};
  const isShipperDisabled = !(configJs !== null && configJs !== void 0 && configJs.shipper) || (configJs === null || configJs === void 0 ? void 0 : (_configJs$shipper = configJs.shipper) === null || _configJs$shipper === void 0 ? void 0 : _configJs$shipper.enabled) === false;
  const diskQueueEnabledInput = (0, _hooks.useSwitchInput)((_output$shipper$disk_ = output === null || output === void 0 ? void 0 : (_output$shipper = output.shipper) === null || _output$shipper === void 0 ? void 0 : _output$shipper.disk_queue_enabled) !== null && _output$shipper$disk_ !== void 0 ? _output$shipper$disk_ : false);
  const diskQueuePathInput = (0, _hooks.useInput)((_output$shipper$disk_2 = output === null || output === void 0 ? void 0 : (_output$shipper2 = output.shipper) === null || _output$shipper2 === void 0 ? void 0 : _output$shipper2.disk_queue_path) !== null && _output$shipper$disk_2 !== void 0 ? _output$shipper$disk_2 : '', undefined, (_diskQueueEnabledInpu = !diskQueueEnabledInput.value) !== null && _diskQueueEnabledInpu !== void 0 ? _diskQueueEnabledInpu : false);
  const diskQueueMaxSizeInput = (0, _hooks.useNumberInput)((_output$shipper$disk_3 = output === null || output === void 0 ? void 0 : (_output$shipper3 = output.shipper) === null || _output$shipper3 === void 0 ? void 0 : _output$shipper3.disk_queue_max_size) !== null && _output$shipper$disk_3 !== void 0 ? _output$shipper$disk_3 : DEFAULT_QUEUE_MAX_SIZE, undefined, (_diskQueueEnabledInpu2 = !diskQueueEnabledInput.value) !== null && _diskQueueEnabledInpu2 !== void 0 ? _diskQueueEnabledInpu2 : false);
  const diskQueueEncryptionEnabled = (0, _hooks.useSwitchInput)((_output$shipper$disk_4 = output === null || output === void 0 ? void 0 : (_output$shipper4 = output.shipper) === null || _output$shipper4 === void 0 ? void 0 : _output$shipper4.disk_queue_encryption_enabled) !== null && _output$shipper$disk_4 !== void 0 ? _output$shipper$disk_4 : false, (_diskQueueEnabledInpu3 = !diskQueueEnabledInput.value) !== null && _diskQueueEnabledInpu3 !== void 0 ? _diskQueueEnabledInpu3 : false);
  const loadBalanceEnabledInput = (0, _hooks.useSwitchInput)((_output$shipper$disk_5 = output === null || output === void 0 ? void 0 : (_output$shipper5 = output.shipper) === null || _output$shipper5 === void 0 ? void 0 : _output$shipper5.disk_queue_enabled) !== null && _output$shipper$disk_5 !== void 0 ? _output$shipper$disk_5 : false);
  const diskQueueCompressionEnabled = (0, _hooks.useSwitchInput)((_output$shipper$disk_6 = output === null || output === void 0 ? void 0 : (_output$shipper6 = output.shipper) === null || _output$shipper6 === void 0 ? void 0 : _output$shipper6.disk_queue_compression_enabled) !== null && _output$shipper$disk_6 !== void 0 ? _output$shipper$disk_6 : false);
  const options = Array.from(Array(10).keys()).slice(1).map(val => {
    return {
      value: `${val}`,
      text: `Level ${val}`
    };
  });
  const compressionLevelInput = (0, _hooks.useSelectInput)(options, (_ref = `${output === null || output === void 0 ? void 0 : (_output$shipper7 = output.shipper) === null || _output$shipper7 === void 0 ? void 0 : _output$shipper7.compression_level}`) !== null && _ref !== void 0 ? _ref : options[0].value, (_diskQueueCompression = !diskQueueCompressionEnabled.value) !== null && _diskQueueCompression !== void 0 ? _diskQueueCompression : false);
  const memQueueEvents = (0, _hooks.useNumberInput)((output === null || output === void 0 ? void 0 : (_output$shipper8 = output.shipper) === null || _output$shipper8 === void 0 ? void 0 : _output$shipper8.mem_queue_events) || undefined);
  const queueFlushTimeout = (0, _hooks.useNumberInput)((output === null || output === void 0 ? void 0 : (_output$shipper9 = output.shipper) === null || _output$shipper9 === void 0 ? void 0 : _output$shipper9.queue_flush_timeout) || undefined);
  const maxBatchBytes = (0, _hooks.useNumberInput)((output === null || output === void 0 ? void 0 : (_output$shipper10 = output.shipper) === null || _output$shipper10 === void 0 ? void 0 : _output$shipper10.max_batch_bytes) || undefined);
  const isSSLEditable = isDisabled('ssl');
  // Logstash inputs
  const logstashHostsInput = (0, _hooks.useComboInput)('logstashHostsComboxBox', (_output$hosts2 = output === null || output === void 0 ? void 0 : output.hosts) !== null && _output$hosts2 !== void 0 ? _output$hosts2 : [], _output_form_validators.validateLogstashHosts, isDisabled('hosts'));
  const sslCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslCertificateAuthoritiesComboxBox', (_output$ssl$certifica = output === null || output === void 0 ? void 0 : (_output$ssl = output.ssl) === null || _output$ssl === void 0 ? void 0 : _output$ssl.certificate_authorities) !== null && _output$ssl$certifica !== void 0 ? _output$ssl$certifica : [], undefined, isSSLEditable);
  const sslCertificateInput = (0, _hooks.useInput)((_output$ssl$certifica2 = output === null || output === void 0 ? void 0 : (_output$ssl2 = output.ssl) === null || _output$ssl2 === void 0 ? void 0 : _output$ssl2.certificate) !== null && _output$ssl$certifica2 !== void 0 ? _output$ssl$certifica2 : '', _output_form_validators.validateSSLCertificate, isSSLEditable);
  const sslKeyInput = (0, _hooks.useInput)((_output$ssl$key = output === null || output === void 0 ? void 0 : (_output$ssl3 = output.ssl) === null || _output$ssl3 === void 0 ? void 0 : _output$ssl3.key) !== null && _output$ssl$key !== void 0 ? _output$ssl$key : '', _output_form_validators.validateSSLKey, isSSLEditable);
  const proxyIdInput = (0, _hooks.useInput)((_output$proxy_id = output === null || output === void 0 ? void 0 : output.proxy_id) !== null && _output$proxy_id !== void 0 ? _output$proxy_id : '', () => undefined, isDisabled('proxy_id'));
  const isLogstash = typeInput.value === 'logstash';
  const inputs = {
    nameInput,
    typeInput,
    elasticsearchUrlInput,
    diskQueueEnabledInput,
    diskQueuePathInput,
    diskQueueEncryptionEnabled,
    diskQueueMaxSizeInput,
    diskQueueCompressionEnabled,
    compressionLevelInput,
    logstashHostsInput,
    additionalYamlConfigInput,
    defaultOutputInput,
    defaultMonitoringOutputInput,
    caTrustedFingerprintInput,
    sslCertificateInput,
    sslKeyInput,
    sslCertificateAuthoritiesInput,
    proxyIdInput,
    loadBalanceEnabledInput,
    memQueueEvents,
    queueFlushTimeout,
    maxBatchBytes
  };
  const hasChanged = Object.values(inputs).some(input => input.hasChanged);
  const validate = (0, _react.useCallback)(() => {
    const nameInputValid = nameInput.validate();
    const elasticsearchUrlsValid = elasticsearchUrlInput.validate();
    const logstashHostsValid = logstashHostsInput.validate();
    const additionalYamlConfigValid = additionalYamlConfigInput.validate();
    const caTrustedFingerprintValid = caTrustedFingerprintInput.validate();
    const sslCertificateValid = sslCertificateInput.validate();
    const sslKeyValid = sslKeyInput.validate();
    const diskQueuePathValid = diskQueuePathInput.validate();
    if (isLogstash) {
      // validate logstash
      return logstashHostsValid && additionalYamlConfigValid && nameInputValid && sslCertificateValid && sslKeyValid;
    } else {
      // validate ES
      return elasticsearchUrlsValid && additionalYamlConfigValid && nameInputValid && caTrustedFingerprintValid && diskQueuePathValid;
    }
  }, [nameInput, elasticsearchUrlInput, logstashHostsInput, additionalYamlConfigInput, caTrustedFingerprintInput, sslCertificateInput, sslKeyInput, diskQueuePathInput, isLogstash]);
  const submit = (0, _react.useCallback)(async () => {
    try {
      if (!validate()) {
        return;
      }
      setIsloading(true);
      let shipperParams = {};
      if (!isShipperDisabled) {
        shipperParams = {
          shipper: {
            mem_queue_events: memQueueEvents.value ? Number(memQueueEvents.value) : null,
            queue_flush_timeout: queueFlushTimeout.value ? Number(queueFlushTimeout.value) : null,
            max_batch_bytes: maxBatchBytes.value ? Number(maxBatchBytes.value) : null
          }
        };
      }
      if (!isShipperDisabled && showExperimentalShipperOptions) {
        shipperParams = {
          ...shipperParams,
          shipper: {
            disk_queue_enabled: diskQueueEnabledInput.value,
            disk_queue_path: diskQueueEnabledInput.value && diskQueuePathInput.value ? diskQueuePathInput.value : '',
            disk_queue_max_size: diskQueueEnabledInput.value && diskQueueMaxSizeInput.value ? diskQueueMaxSizeInput.value : null,
            disk_queue_encryption_enabled: diskQueueEnabledInput.value && diskQueueEncryptionEnabled.value,
            disk_queue_compression_enabled: diskQueueCompressionEnabled.value,
            compression_level: diskQueueCompressionEnabled.value ? Number(compressionLevelInput.value) : null,
            loadbalance: loadBalanceEnabledInput.value
          }
        };
      }
      const proxyIdValue = proxyIdInput.value !== '' ? proxyIdInput.value : null;
      const data = isLogstash ? {
        name: nameInput.value,
        type: typeInput.value,
        hosts: logstashHostsInput.value,
        is_default: defaultOutputInput.value,
        is_default_monitoring: defaultMonitoringOutputInput.value,
        config_yaml: additionalYamlConfigInput.value,
        ssl: {
          certificate: sslCertificateInput.value,
          key: sslKeyInput.value,
          certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== '')
        },
        proxy_id: proxyIdValue,
        ...shipperParams
      } : {
        name: nameInput.value,
        type: typeInput.value,
        hosts: elasticsearchUrlInput.value,
        is_default: defaultOutputInput.value,
        is_default_monitoring: defaultMonitoringOutputInput.value,
        config_yaml: additionalYamlConfigInput.value,
        ca_trusted_fingerprint: caTrustedFingerprintInput.value,
        proxy_id: proxyIdValue,
        ...shipperParams
      };
      if (output) {
        // Update
        if (!(await (0, _confirm_update.confirmUpdate)(output, confirm))) {
          setIsloading(false);
          return;
        }
        const res = await (0, _hooks.sendPutOutput)(output.id, data);
        if (res.error) {
          throw res.error;
        }
      } else {
        // Create
        const res = await (0, _hooks.sendPostOutput)(data);
        if (res.error) {
          throw res.error;
        }
      }
      onSucess();
      setIsloading(false);
    } catch (err) {
      setIsloading(false);
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.outputForm.errorToastTitle', {
          defaultMessage: 'Error while saving output'
        })
      });
    }
  }, [validate, isShipperDisabled, showExperimentalShipperOptions, proxyIdInput.value, isLogstash, nameInput.value, typeInput.value, logstashHostsInput.value, defaultOutputInput.value, defaultMonitoringOutputInput.value, additionalYamlConfigInput.value, sslCertificateInput.value, sslKeyInput.value, sslCertificateAuthoritiesInput.value, elasticsearchUrlInput.value, caTrustedFingerprintInput.value, output, onSucess, memQueueEvents.value, queueFlushTimeout.value, maxBatchBytes.value, diskQueueEnabledInput.value, diskQueuePathInput.value, diskQueueMaxSizeInput.value, diskQueueEncryptionEnabled.value, diskQueueCompressionEnabled.value, compressionLevelInput.value, loadBalanceEnabledInput.value, confirm, notifications.toasts]);
  return {
    inputs,
    submit,
    isLoading,
    hasEncryptedSavedObjectConfigured,
    isShipperEnabled: !isShipperDisabled,
    isDisabled: isLoading || output && !hasChanged || isLogstash && !hasEncryptedSavedObjectConfigured
  };
}