"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmUpdate = confirmUpdate;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _agent_and_policies_count = require("../../services/agent_and_policies_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.updateOutput.confirmModalTitle",
  defaultMessage: "Save and deploy changes?"
});
const ConfirmDescription = ({
  output,
  agentCount,
  agentPolicyCount
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  "data-test-subj": "settings.outputModal",
  id: "xpack.fleet.settings.updateOutput.confirmModalText",
  defaultMessage: "This action will update {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",
  values: {
    outputName: /*#__PURE__*/_react.default.createElement("strong", null, output.name),
    agents: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.updateOutput.agentsCount",
      defaultMessage: "{agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      }
    })),
    policies: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.updateOutput.agentPolicyCount",
      defaultMessage: "{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",
      values: {
        agentPolicyCount
      }
    }))
  }
}), output.type === 'logstash' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "warning",
  color: "warning",
  size: "m",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.updateOutput.warningTitle",
    defaultMessage: "Logstash output for agent integration is not supported for fleet server."
  })
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.updateOutput.warningMessage",
  defaultMessage: "Fleet server policies will keep using the existing ES output."
})), ' ') : null);
async function confirmUpdate(output, confirm) {
  const {
    agentCount,
    agentPolicyCount
  } = await (0, _agent_and_policies_count.getAgentAndPolicyCountForOutput)(output);
  return confirm( /*#__PURE__*/_react.default.createElement(ConfirmTitle, null), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
    agentCount: agentCount,
    agentPolicyCount: agentPolicyCount,
    output: output
  }));
}