"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreconfigurationDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _constants = require("../../../constants");
var _ = require("..");
var _code_block = require("./code_block");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchPreconfiguredPolicies = async () => {
  var _response$data$items, _response$data;
  const kuery = `${_constants.AGENT_POLICY_SAVED_OBJECT_TYPE}.is_preconfigured:true`;
  const response = await (0, _hooks.sendGetAgentPolicies)({
    kuery,
    perPage: _constants.SO_SEARCH_LIMIT,
    full: true
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  return (_response$data$items = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items) !== null && _response$data$items !== void 0 ? _response$data$items : [];
};
const PreconfigurationDebugger = () => {
  var _preconfiguredPolicie, _preconfiguredPolicie2, _preconfiguredPolicie3, _preconfiguredPolicie4;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)();
  const [isResetModalVisible, setIsResetModalVisible] = (0, _react.useState)(false);
  const [isResetAllModalVisible, setIsResetAllModalVisible] = (0, _react.useState)(false);
  const preconfiguredPolicies = (0, _reactQuery.useQuery)(['debug-preconfigured-policies'], fetchPreconfiguredPolicies);
  const comboBoxOptions = (_preconfiguredPolicie = (_preconfiguredPolicie2 = preconfiguredPolicies.data) === null || _preconfiguredPolicie2 === void 0 ? void 0 : _preconfiguredPolicie2.map(policy => ({
    label: policy.name,
    value: policy.id
  }))) !== null && _preconfiguredPolicie !== void 0 ? _preconfiguredPolicie : [];
  const selectedOptions = selectedPolicyId ? [comboBoxOptions.find(({
    value
  }) => value === selectedPolicyId)] : [];
  const selectedPolicy = (_preconfiguredPolicie3 = preconfiguredPolicies.data) === null || _preconfiguredPolicie3 === void 0 ? void 0 : _preconfiguredPolicie3.find(policy => policy.id === selectedPolicyId);
  const resetOnePolicyMutation = (0, _reactQuery.useMutation)(async policyId => {
    const response = await (0, _hooks.sendResetOnePreconfiguredAgentPolicy)(policyId);
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetError', {
          defaultMessage: 'Error resetting policy'
        }),
        toastMessage: response.error.message
      });
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetSuccess', {
      defaultMessage: 'Successfully reset policy'
    }));
    _.queryClient.invalidateQueries(['debug-preconfigured-policies']);
    setSelectedPolicyId(undefined);
    setIsResetModalVisible(false);
    return response.data;
  });
  const resetAllPoliciesMutation = (0, _reactQuery.useMutation)(async () => {
    const response = await (0, _hooks.sendResetAllPreconfiguredAgentPolicies)();
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllError', {
          defaultMessage: 'Error resetting policies'
        }),
        toastMessage: response.error.message
      });
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllSuccess', {
      defaultMessage: 'Successfully reset policies'
    }));
    _.queryClient.invalidateQueries(['debug-preconfigured-policies']);
    setSelectedPolicyId(undefined);
    setIsResetAllModalVisible(false);
    return response.data;
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.description",
    defaultMessage: "This tool can be used to reset preconfigured policies that are managed via {codeKibanaYml}. This includes Fleet's default policies that may exist in cloud environments.",
    values: {
      codeKibanaYml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kibana.yml")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetInstructions",
    defaultMessage: "You may reset a single preconfigured policy or use the \"Reset all\" button to reset all preconfigured policies at once."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 400px;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.selectLabel', {
      defaultMessage: 'Select a preconfigured policy'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.selectLabel', {
      defaultMessage: 'Select a preconfigured policy'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    onChange: newSelectedOptions => {
      if (!newSelectedOptions.length) {
        setSelectedPolicyId(undefined);
      } else {
        setSelectedPolicyId(newSelectedOptions[0].value);
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    isDisabled: !selectedPolicyId,
    onClick: () => setIsResetModalVisible(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetButton",
    defaultMessage: "Reset"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    isDisabled: !((_preconfiguredPolicie4 = preconfiguredPolicies.data) !== null && _preconfiguredPolicie4 !== void 0 && _preconfiguredPolicie4.length),
    onClick: () => setIsResetAllModalVisible(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetAllButton",
    defaultMessage: "Reset all"
  }))))), isResetModalVisible && selectedPolicy && selectedPolicyId && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetModalTitle', {
      defaultMessage: 'Reset {policyName}',
      values: {
        policyName: selectedPolicy.name
      }
    }),
    onCancel: () => setIsResetModalVisible(false),
    onConfirm: () => resetOnePolicyMutation.mutate(selectedPolicyId),
    isLoading: resetOnePolicyMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetModalCancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetModalConfirm', {
      defaultMessage: 'Reset'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetModalBody",
    defaultMessage: "Are you sure you want to reset {policyName}?",
    values: {
      policyName: selectedPolicy.name
    }
  })), isResetAllModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllModalTitle', {
      defaultMessage: 'Reset all preconfigured policies'
    }),
    onCancel: () => setIsResetAllModalVisible(false),
    onConfirm: () => resetAllPoliciesMutation.mutate(),
    isLoading: resetAllPoliciesMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllModalCancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllModalConfirm', {
      defaultMessage: 'Reset all'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetAllModalBody",
    defaultMessage: "Are you sure you want to reset all preconfigured policies?"
  })), selectedPolicyId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getHref('policy_details', {
      policyId: selectedPolicyId
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.viewAgentPolicyLink",
    defaultMessage: "View Agent Policy in Fleet UI"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    value: JSON.stringify(selectedPolicy, null, 2)
  })));
};
exports.PreconfigurationDebugger = PreconfigurationDebugger;