"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _data_stream_row_actions = require("./components/data_stream_row_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamListPage = () => {
  (0, _hooks.useBreadcrumbs)('data_streams');
  const {
    pagination,
    pageSizeOptions
  } = (0, _hooks.usePagination)();

  // Fetch data streams
  const {
    isLoading,
    data: dataStreamsData,
    resendRequest
  } = (0, _hooks.useGetDataStreams)();

  // Some policies retrieved, set up table props
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      field: 'dataset',
      sortable: true,
      width: '25%',
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.datasetColumnTitle', {
        defaultMessage: 'Dataset'
      })
    }, {
      field: 'type',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.typeColumnTitle', {
        defaultMessage: 'Type'
      })
    }, {
      field: 'namespace',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.namespaceColumnTitle', {
        defaultMessage: 'Namespace'
      }),
      render: namespace => {
        return namespace ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow"
        }, namespace) : '';
      }
    }, {
      field: 'package',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.integrationColumnTitle', {
        defaultMessage: 'Integration'
      }),
      render(pkg, datastream) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, datastream.package_version && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
          packageName: pkg,
          version: datastream.package_version,
          size: "m",
          tryApi: true
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, pkg));
      }
    }, {
      field: 'last_activity_ms',
      sortable: true,
      width: '25%',
      dataType: 'date',
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.lastActivityColumnTitle', {
        defaultMessage: 'Last activity'
      }),
      render: date => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
          value: date,
          year: "numeric",
          month: "short",
          day: "numeric"
        }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " @ "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
          value: date,
          hour: "numeric",
          minute: "numeric",
          second: "numeric"
        }));
      }
    }, {
      field: 'size_in_bytes',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.sizeColumnTitle', {
        defaultMessage: 'Size'
      }),
      render: (_, datastream) => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, datastream.size_in_bytes_formatted);
      }
    }, {
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: datastream => /*#__PURE__*/_react.default.createElement(_data_stream_row_actions.DataStreamRowActions, {
          datastream: datastream
        })
      }]
    }];
    return cols;
  }, []);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.dataStreamList.noDataStreamsPrompt",
      defaultMessage: "No data streams"
    }))
  }), []);
  const filterOptions = {
    dataset: [],
    type: [],
    namespace: [],
    package: []
  };
  if (dataStreamsData && dataStreamsData.data_streams.length) {
    const dataValues = {
      dataset: [],
      type: [],
      namespace: [],
      package: []
    };
    dataStreamsData.data_streams.forEach(stream => {
      const {
        dataset,
        type,
        namespace,
        package: pkg
      } = stream;
      if (!dataValues.dataset.includes(dataset)) {
        dataValues.dataset.push(dataset);
      }
      if (!dataValues.type.includes(type)) {
        dataValues.type.push(type);
      }
      if (!dataValues.namespace.includes(namespace)) {
        dataValues.namespace.push(namespace);
      }
      if (!dataValues.package.includes(pkg)) {
        dataValues.package.push(pkg);
      }
    });
    for (const field in dataValues) {
      if (filterOptions[field]) {
        filterOptions[field] = dataValues[field].sort().map(option => ({
          value: option,
          name: option
        }));
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoading,
    hasActions: true,
    tableLayout: "auto",
    message: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.dataStreamList.loadingDataStreamsMessage",
      defaultMessage: "Loading data streams\u2026"
    }) : dataStreamsData && !dataStreamsData.data_streams.length ? emptyPrompt : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",
      defaultMessage: "No matching data streams found"
    }),
    items: dataStreamsData ? dataStreamsData.data_streams : [],
    itemId: "index",
    columns: columns,
    pagination: {
      initialPageSize: pagination.pageSize,
      pageSizeOptions
    },
    sorting: true,
    search: {
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "reloadButton",
        color: "primary",
        iconType: "refresh",
        onClick: () => resendRequest()
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.dataStreamList.reloadDataStreamsButtonText",
        defaultMessage: "Reload"
      }))],
      box: {
        placeholder: _i18n.i18n.translate('xpack.fleet.dataStreamList.searchPlaceholderTitle', {
          defaultMessage: 'Filter data streams'
        }),
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'dataset',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.datasetColumnTitle', {
          defaultMessage: 'Dataset'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.dataset
      }, {
        type: 'field_value_selection',
        field: 'type',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.typeColumnTitle', {
          defaultMessage: 'Type'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.type
      }, {
        type: 'field_value_selection',
        field: 'namespace',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.namespaceColumnTitle', {
          defaultMessage: 'Namespace'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.namespace
      }, {
        type: 'field_value_selection',
        field: 'package',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.integrationColumnTitle', {
          defaultMessage: 'Integration'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.package
      }]
    }
  });
};
exports.DataStreamListPage = DataStreamListPage;