"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerRequirementPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../hooks");
var _fleet_server_callouts = require("../components/fleet_server_callouts");
var _components = require("../components");
var _components2 = require("../../../components");
var _components3 = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexItemWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0px;
  max-width: 100%;
`;
const ContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
  margin: 0 auto;
`;
const FleetServerRequirementPage = ({
  showStandaloneTab = () => {},
  showEnrollmentRecommendation = true
}) => {
  var _startService$cloud;
  const startService = (0, _hooks.useStartServices)();
  const deploymentUrl = (_startService$cloud = startService.cloud) === null || _startService$cloud === void 0 ? void 0 : _startService$cloud.deploymentUrl;
  const [isPermissionsLoading, setIsPermissionsLoading] = (0, _react.useState)(false);
  const [permissionsError, setPermissionsError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function checkPermissions() {
      setIsPermissionsLoading(false);
      setPermissionsError(undefined);
      try {
        var _permissionsResponse$;
        setIsPermissionsLoading(true);
        const permissionsResponse = await (0, _hooks.sendGetPermissionsCheck)(true);
        setIsPermissionsLoading(false);
        if (!((_permissionsResponse$ = permissionsResponse.data) !== null && _permissionsResponse$ !== void 0 && _permissionsResponse$.success)) {
          var _permissionsResponse$2;
          setPermissionsError(((_permissionsResponse$2 = permissionsResponse.data) === null || _permissionsResponse$2 === void 0 ? void 0 : _permissionsResponse$2.error) || 'REQUEST_ERROR');
        }
      } catch (err) {
        setPermissionsError('REQUEST_ERROR');
      }
    }
    checkPermissions();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ContentWrapper, {
    gutterSize: "none",
    justifyContent: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
    grow: false
  }, deploymentUrl ? /*#__PURE__*/_react.default.createElement(_components3.CloudInstructions, {
    deploymentUrl: deploymentUrl
  }) : isPermissionsLoading ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : permissionsError ? /*#__PURE__*/_react.default.createElement(_fleet_server_callouts.FleetServerMissingPrivileges, null) : showEnrollmentRecommendation ? /*#__PURE__*/_react.default.createElement(_components3.EnrollmentRecommendation, {
    showStandaloneTab: showStandaloneTab
  }) : /*#__PURE__*/_react.default.createElement(_components2.AddFleetServerLanding, null))));
};
exports.FleetServerRequirementPage = FleetServerRequirementPage;