"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentTableHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _status_bar = require("./status_bar");
var _agents_selection_status = require("./agents_selection_status");
var _status_badges = require("./status_badges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentTableHeader = ({
  agentStatus,
  totalAgents,
  selectableAgents,
  selectionMode,
  setSelectionMode,
  selectedAgents,
  setSelectedAgents,
  showInactive,
  clearFilters,
  isUsingFilter
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_agents_selection_status.AgentsSelectionStatus, {
    totalAgents: totalAgents,
    selectableAgents: selectableAgents,
    selectionMode: selectionMode,
    setSelectionMode: setSelectionMode,
    selectedAgents: selectedAgents,
    setSelectedAgents: setSelectedAgents
  })), isUsingFilter ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => clearFilters()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.header.clearFiltersLinkText",
    defaultMessage: "Clear filters"
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, agentStatus && /*#__PURE__*/_react.default.createElement(_status_badges.AgentStatusBadges, {
    showInactive: showInactive,
    agentStatus: agentStatus
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), agentStatus && /*#__PURE__*/_react.default.createElement(_status_bar.AgentStatusBar, {
    agentStatus: agentStatus
  }));
};
exports.AgentTableHeader = AgentTableHeader;