"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusFilter = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusFilters = [{
  status: 'healthy',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusHealthyFilterText', {
    defaultMessage: 'Healthy'
  })
}, {
  status: 'unhealthy',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUnhealthyFilterText', {
    defaultMessage: 'Unhealthy'
  })
}, {
  status: 'updating',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUpdatingFilterText', {
    defaultMessage: 'Updating'
  })
}, {
  status: 'offline',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusOfflineFilterText', {
    defaultMessage: 'Offline'
  })
}, {
  status: 'inactive',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusInactiveFilterText', {
    defaultMessage: 'Inactive'
  })
}, {
  status: 'unenrolled',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUnenrolledFilterText', {
    defaultMessage: 'Unenrolled'
  })
}];
const LeftpaddedNotificationBadge = (0, _styledComponents.default)(_eui.EuiNotificationBadge)`
  margin-left: 10px;
`;
const TourStepNoHeaderFooter = (0, _styledComponents.default)(_eui.EuiTourStep)`
  .euiTourFooter {
    display: none;
  }
  .euiTourHeader {
    display: none;
  }
`;
const InactiveAgentsTourStep = ({
  children,
  isOpen
}) => /*#__PURE__*/_react.default.createElement(TourStepNoHeaderFooter, {
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.inactiveAgentsTourStepContent",
    defaultMessage: "Some agents have become inactive and have been hidden. Use status filters to show inactive or unenrolled agents."
  })),
  isStepOpen: isOpen,
  minWidth: 300,
  step: 1,
  stepsTotal: 0,
  title: "",
  onFinish: () => {},
  anchorPosition: "upCenter",
  maxWidth: 280
}, children);
const AgentStatusFilter = props => {
  const {
    selectedStatus,
    onSelectedStatusChange,
    disabled,
    totalInactiveAgents,
    isOpenByDefault = false
  } = props;
  const [lastSeenInactiveAgentsCount, setLastSeenInactiveAgentsCount] = (0, _hooks.useLastSeenInactiveAgentsCount)();
  const [inactiveAgentsCalloutHasBeenDismissed, setInactiveAgentsCalloutHasBeenDismissed] = (0, _hooks.useInactiveAgentsCalloutHasBeenDismissed)();
  const newlyInactiveAgentsCount = (0, _react.useMemo)(() => {
    const newVal = totalInactiveAgents - lastSeenInactiveAgentsCount;
    if (newVal < 0) {
      return 0;
    }
    return newVal;
  }, [lastSeenInactiveAgentsCount, totalInactiveAgents]);
  (0, _react.useMemo)(() => {
    if (selectedStatus.length && selectedStatus.includes('inactive') && newlyInactiveAgentsCount) {
      setLastSeenInactiveAgentsCount(totalInactiveAgents);
    }
  }, [selectedStatus, newlyInactiveAgentsCount, setLastSeenInactiveAgentsCount, totalInactiveAgents]);
  (0, _react.useMemo)(() => {
    // reduce the number of last seen inactive agents count to the total inactive agents count
    // e.g if agents have become healthy again
    if (totalInactiveAgents > 0 && lastSeenInactiveAgentsCount > totalInactiveAgents) {
      setLastSeenInactiveAgentsCount(totalInactiveAgents);
    }
  }, [lastSeenInactiveAgentsCount, totalInactiveAgents, setLastSeenInactiveAgentsCount]);

  // Status for filtering
  const [isStatusFilterOpen, setIsStatusFilterOpen] = (0, _react.useState)(isOpenByDefault);
  const updateIsStatusFilterOpen = isOpen => {
    if (isOpen && newlyInactiveAgentsCount > 0 && !inactiveAgentsCalloutHasBeenDismissed) {
      setInactiveAgentsCalloutHasBeenDismissed(true);
    }
    setIsStatusFilterOpen(isOpen);
  };
  return /*#__PURE__*/_react.default.createElement(InactiveAgentsTourStep, {
    isOpen: newlyInactiveAgentsCount > 0 && !inactiveAgentsCalloutHasBeenDismissed
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => updateIsStatusFilterOpen(!isStatusFilterOpen),
      isSelected: isStatusFilterOpen,
      hasActiveFilters: selectedStatus.length > 0,
      numActiveFilters: selectedStatus.length,
      numFilters: statusFilters.length,
      disabled: disabled,
      "data-test-subj": "agentList.statusFilter"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.statusFilterText",
      defaultMessage: "Status"
    })),
    isOpen: isStatusFilterOpen,
    closePopover: () => updateIsStatusFilterOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFilterSelect__items"
  }, statusFilters.map(({
    label,
    status
  }, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    key: idx,
    checked: selectedStatus.includes(status) ? 'on' : undefined,
    onClick: () => {
      if (selectedStatus.includes(status)) {
        onSelectedStatusChange([...selectedStatus.filter(s => s !== status)]);
      } else {
        onSelectedStatusChange([...selectedStatus, status]);
      }
    }
  }, /*#__PURE__*/_react.default.createElement("span", null, label, status === 'inactive' && newlyInactiveAgentsCount > 0 && /*#__PURE__*/_react.default.createElement(LeftpaddedNotificationBadge, null, newlyInactiveAgentsCount)))))));
};
exports.AgentStatusFilter = AgentStatusFilter;