"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../constants");
var _hooks = require("../../hooks");
var _layouts = require("../../layouts");
var _list_page = require("./list_page");
var _details_page = require("./details_page");
var _edit_package_policy_page = require("./edit_package_policy_page");
var _upgrade_package_policy_page = require("./upgrade_package_policy_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyApp = () => {
  (0, _hooks.useBreadcrumbs)('policies');
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.edit_integration
  }, /*#__PURE__*/_react.default.createElement(_edit_package_policy_page.EditPackagePolicyPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.upgrade_package_policy
  }, /*#__PURE__*/_react.default.createElement(_upgrade_package_policy_page.UpgradePackagePolicyPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policy_details
  }, /*#__PURE__*/_react.default.createElement(_details_page.AgentPolicyDetailsPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policies_list
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "agent_policies"
  }, /*#__PURE__*/_react.default.createElement(_list_page.AgentPolicyListPage, null)))));
};
exports.AgentPolicyApp = AgentPolicyApp;