"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentPageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _confirm_agent_enrollment = require("../../../../../../../../../components/agent_enrollment_flyout/confirm_agent_enrollment");
var _install_agent_managed = require("./install_agent_managed");
var _install_agent_standalone = require("./install_agent_standalone");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallElasticAgentPageStep = props => {
  var _props$agentPolicy;
  const [localIsManaged, setLocalIsManaged] = (0, _react.useState)(props.isManaged);
  const [useLocalState, setUseLocalState] = (0, _react.useState)(false);
  const enrolledAgentIds = (0, _confirm_agent_enrollment.usePollingAgentCount)(((_props$agentPolicy = props.agentPolicy) === null || _props$agentPolicy === void 0 ? void 0 : _props$agentPolicy.id) || '', {
    noLowerTimeLimit: true,
    pollImmediately: true
  });
  const onNext = () => {
    props.setEnrolledAgentIds(enrolledAgentIds);
    props.onNext();
  };
  const managedPageProps = {
    ...props,
    onNext,
    enrolledAgentIds,
    setIsManaged: useLocalState ? setLocalIsManaged : props.setIsManaged
  };
  if (localIsManaged) {
    return /*#__PURE__*/_react.default.createElement(_install_agent_managed.InstallElasticAgentManagedPageStep, managedPageProps);
  }
  const standalonePageProps = {
    ...props,
    onNext,
    enrolledAgentIds,
    setIsManaged: newIsManaged => {
      if (newIsManaged) {
        // once you are in the standalone set of steps and the package policy
        // has been created, there is no going back to the managed steps.
        // instead only this page view is toggled.
        setUseLocalState(true);
      }
      setLocalIsManaged(newIsManaged);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_install_agent_standalone.InstallElasticAgentStandalonePageStep, standalonePageProps);
};
exports.InstallElasticAgentPageStep = InstallElasticAgentPageStep;