"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmIncomingDataWithPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _omit = _interopRequireDefault(require("lodash/omit"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../../../../hooks");
var _use_get_agent_incoming_data = require("../../../../../../../components/agent_enrollment_flyout/use_get_agent_incoming_data");
var _confirm_incoming_data_timeout = require("./confirm_incoming_data_timeout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_AGENT_DATA_PREVIEW_COUNT = 5;
// make room for more interesting keys in the UI
const DATA_PREVIEW_OMIT_KEYS = ['agent.ephemeral_id', 'agent.id', 'elastic_agent.id', 'data_stream.namespace', '@timestamp'];
const CleanOverflowDescriptionList = (0, _styledComponents.default)(_eui.EuiDescriptionList)`
  overflow: hidden;
  max-height: 125px;
  word-break: break-all;
  white-space: pre-wrap;
`;

// &&& increases the style priority
const CompressedPre = (0, _styledComponents.default)('pre')`
  &&& {
    background: none;
    padding: 0 0;
  }
`;
const HitPreview = ({
  hit
}) => {
  const hitForDisplay = (0, _omit.default)((0, _std.getFlattenedObject)(hit._source), DATA_PREVIEW_OMIT_KEYS);
  const listItems = Object.entries(hitForDisplay).map(([key, value]) => ({
    title: `${key}:`,
    // Ensures arrays and collections of nested objects are displayed correctly
    description: JSON.stringify(value)
  }));
  return /*#__PURE__*/_react.default.createElement("pre", null, /*#__PURE__*/_react.default.createElement("code", null, /*#__PURE__*/_react.default.createElement(CleanOverflowDescriptionList, {
    listItems: listItems,
    type: "inline",
    align: "left",
    compressed: true
  })));
};
const HitTimestamp = ({
  hit
}) => {
  const source = (hit === null || hit === void 0 ? void 0 : hit._source) || {};
  const timestamp = (source === null || source === void 0 ? void 0 : source['@timestamp']) || '-';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement(CompressedPre, null, timestamp ? (0, _eui.formatDate)(timestamp, 'MMM D, YYYY @ HH:mm:ss.SSS') : '-'));
};
const AgentDataPreview = ({
  dataPreview
}) => {
  const previewData = dataPreview.slice(0, MAX_AGENT_DATA_PREVIEW_COUNT);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, previewData.map(hit => /*#__PURE__*/_react.default.createElement("div", {
    id: hit._id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '220px'
    }
  }, /*#__PURE__*/_react.default.createElement(HitTimestamp, {
    hit: hit
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(HitPreview, {
    hit: hit
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }))));
};
const ConfirmIncomingDataWithPreview = ({
  agentIds,
  packageInfo,
  agentDataConfirmed,
  setAgentDataConfirmed,
  troubleshootLink
}) => {
  const {
    incomingData,
    dataPreview,
    isLoading,
    hasReachedTimeout
  } = (0, _use_get_agent_incoming_data.usePollingIncomingData)(agentIds, true, MAX_AGENT_DATA_PREVIEW_COUNT);
  const {
    enrolledAgents,
    numAgentsWithData
  } = (0, _use_get_agent_incoming_data.useGetAgentIncomingData)(incomingData, packageInfo);
  const isGuidedOnboardingActive = (0, _hooks.useIsGuidedOnboardingActive)(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name);
  const {
    guidedOnboarding
  } = (0, _hooks.useStartServices)();
  if (!isLoading && enrolledAgents > 0 && numAgentsWithData > 0) {
    setAgentDataConfirmed(true);
    if (isGuidedOnboardingActive) {
      var _guidedOnboarding$gui;
      (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui === void 0 ? void 0 : _guidedOnboarding$gui.completeGuidedOnboardingForIntegration(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name);
    }
  }
  if (!agentDataConfirmed) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "primary",
      iconType: _eui.EuiLoadingSpinner,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingDataWithPreview.listening",
        defaultMessage: "Listening for incoming data from enrolled agents..."
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), hasReachedTimeout ? /*#__PURE__*/_react.default.createElement(_confirm_incoming_data_timeout.ConfirmIncomingDataTimeout, {
      agentIds: agentIds,
      troubleshootLink: troubleshootLink,
      packageInfo: packageInfo
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.confirmIncomingDataWithPreview.loading",
      defaultMessage: "It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: troubleshootLink
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.enrollmentInstructions.troubleshootingLink",
          defaultMessage: "troubleshooting guide"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "IncomingDataConfirmedCallOut",
    title: _i18n.i18n.translate('xpack.fleet.confirmIncomingDataWithPreview.title', {
      defaultMessage: 'Incoming data received from {numAgentsWithData} enrolled { numAgentsWithData, plural, one {agent} other {agents}}.',
      values: {
        numAgentsWithData
      }
    }),
    color: "success",
    iconType: "check"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingDataWithPreview.previewTitle",
    defaultMessage: "Preview of incoming data:"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(AgentDataPreview, {
    dataPreview: dataPreview
  }));
};
exports.ConfirmIncomingDataWithPreview = ConfirmIncomingDataWithPreview;