"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefinePackagePolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _components = require("../../../../../components");
var _hooks = require("../../../../../hooks");
var _services = require("../../services");
var _components2 = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// on smaller screens, fields should be displayed in one column
const FormGroupResponsiveFields = (0, _styledComponents.default)(_eui.EuiDescribedFormGroup)`
  @media (max-width: 767px) {
    [class*='euiFlexGroup-responsive'] {
      align-items: flex-start;
    }
  }
`;
const StepDefinePackagePolicy = /*#__PURE__*/(0, _react.memo)(({
  agentPolicy,
  packageInfo,
  packagePolicy,
  updatePackagePolicy,
  validationResults,
  submitAttempted,
  noAdvancedToggle = false,
  isEditPage = false
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();

  // Form show/hide states
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(noAdvancedToggle);

  // Package-level vars
  const requiredVars = [];
  const advancedVars = [];
  if (packageInfo.vars) {
    packageInfo.vars.forEach(varDef => {
      if ((0, _services.isAdvancedVar)(varDef)) {
        advancedVars.push(varDef);
      } else {
        requiredVars.push(varDef);
      }
    });
  }
  const isManaged = packagePolicy.is_managed;
  return validationResults ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.managedReadonly",
      defaultMessage: "This is a managed package policy. You cannot modify it here."
    }),
    iconType: "lock"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(FormGroupResponsiveFields, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.integrationSettingsSectionTitle",
      defaultMessage: "Integration settings"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.integrationSettingsSectionDescription",
      defaultMessage: "Choose a name and description to help identify how this integration will be used."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !!validationResults.name,
    error: validationResults.name,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNameInputLabel",
      defaultMessage: "Integration name"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: isManaged,
    value: packagePolicy.name,
    onChange: e => updatePackagePolicy({
      name: e.target.value
    }),
    "data-test-subj": "packagePolicyNameInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDescriptionInputLabel",
      defaultMessage: "Description"
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.inputVarFieldOptionalLabel",
      defaultMessage: "Optional"
    })),
    isInvalid: !!validationResults.description,
    error: validationResults.description
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: isManaged,
    value: packagePolicy.description,
    onChange: e => updatePackagePolicy({
      description: e.target.value
    }),
    "data-test-subj": "packagePolicyDescriptionInput"
  }))), requiredVars.map(varDef => {
    var _validationResults$va, _validationResults$va2;
    const {
      name: varName,
      type: varType
    } = varDef;
    if (!packagePolicy.vars || !packagePolicy.vars[varName]) return null;
    const value = packagePolicy.vars[varName].value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName
    }, /*#__PURE__*/_react.default.createElement(_components2.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicy({
          vars: {
            ...packagePolicy.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_validationResults$va = validationResults === null || validationResults === void 0 ? void 0 : (_validationResults$va2 = validationResults.vars) === null || _validationResults$va2 === void 0 ? void 0 : _validationResults$va2[varName]) !== null && _validationResults$va !== void 0 ? _validationResults$va : [],
      forceShowErrors: submitAttempted
    }));
  }), !noAdvancedToggle && !isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: isShowingAdvanced ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",
    defaultMessage: "Advanced options"
  }))), !isShowingAdvanced && !!validationResults.namespace ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: 1
    }
  }))) : null)), isShowingAdvanced ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !!validationResults.namespace,
    error: validationResults.namespace,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceInputLabel",
      defaultMessage: "Namespace"
    }),
    helpText: isEditPage && packageInfo.type === 'input' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyInputOnlyEditNamespaceHelpLabel",
      defaultMessage: "The namespace cannot be changed for this integration. Create a new integration policy to use a different namespace."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceHelpLabel",
      defaultMessage: "Change the default namespace inherited from the selected Agent policy. This setting changes the name of the integration's data stream. {learnMore}.",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsNamingScheme,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceHelpLearnMoreLabel', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    isDisabled: isEditPage && packageInfo.type === 'input',
    singleSelection: true,
    selectedOptions: packagePolicy.namespace ? [{
      label: packagePolicy.namespace
    }] : [],
    onCreateOption: newNamespace => {
      updatePackagePolicy({
        namespace: newNamespace
      });
    },
    onChange: newNamespaces => {
      updatePackagePolicy({
        namespace: newNamespaces.length ? newNamespaces[0].label : ''
      });
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataRetentionLabel",
      defaultMessage: "Data retention settings"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataRetentionText",
      defaultMessage: "By default all logs and metrics data are stored on the hot tier. {learnMore} about changing the data retention policy for this integration.",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsILM,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataRetentionLearnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement("div", null))), advancedVars.map(varDef => {
    var _validationResults$va3, _validationResults$va4;
    const {
      name: varName,
      type: varType
    } = varDef;
    if (!packagePolicy.vars || !packagePolicy.vars[varName]) return null;
    const value = packagePolicy.vars[varName].value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName
    }, /*#__PURE__*/_react.default.createElement(_components2.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicy({
          vars: {
            ...packagePolicy.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_validationResults$va3 = validationResults === null || validationResults === void 0 ? void 0 : (_validationResults$va4 = validationResults.vars) === null || _validationResults$va4 === void 0 ? void 0 : _validationResults$va4[varName]) !== null && _validationResults$va3 !== void 0 ? _validationResults$va3 : [],
      forceShowErrors: submitAttempted
    }));
  }))) : null))) : /*#__PURE__*/_react.default.createElement(_components.Loading, null);
});
exports.StepDefinePackagePolicy = StepDefinePackagePolicy;