"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _agent_policy_advanced_fields = require("./agent_policy_advanced_fields");
var _agent_policy_general_fields = require("./agent_policy_general_fields");
var _agent_policy_system_monitoring_field = require("./agent_policy_system_monitoring_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .ingest-active-button {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const AgentPolicyForm = ({
  agentPolicy,
  updateAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation,
  isEditing = false,
  onDelete = () => {}
}) => {
  const generalSettingsWrapper = children => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.generalSettingsGroupTitle",
      defaultMessage: "General settings"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.generalSettingsGroupDescription",
      defaultMessage: "Choose a name and description for your agent policy."
    })
  }, children);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, !isEditing ? /*#__PURE__*/_react.default.createElement(_agent_policy_general_fields.AgentPolicyGeneralFields, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation
  }) : generalSettingsWrapper([/*#__PURE__*/_react.default.createElement(_agent_policy_general_fields.AgentPolicyGeneralFields, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation
  })]), !isEditing ? /*#__PURE__*/_react.default.createElement(_agent_policy_system_monitoring_field.AgentPolicyFormSystemMonitoringCheckbox, {
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: updateSysMonitoring
  }) : null, !isEditing ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advancedOptions",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.advancedOptionsToggleLabel",
      defaultMessage: "Advanced options"
    }),
    buttonClassName: "ingest-active-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    isEditing: isEditing,
    onDelete: onDelete
  }))) : /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    isEditing: isEditing,
    onDelete: onDelete
  }));
};
exports.AgentPolicyForm = AgentPolicyForm;