"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyAdvancedOptionsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../../../../../components");
var _agent_policy_delete_provider = require("../agent_policy_delete_provider");
var _services = require("../../../../services");
var _hooks2 = require("./hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyAdvancedOptionsContent = ({
  agentPolicy,
  updateAgentPolicy,
  validation,
  isEditing = false,
  onDelete = () => {}
}) => {
  var _config$developer$max, _config$developer, _agentPoliciesData$to, _agentPolicy$package_, _agentPolicy$is_prote, _agentPolicy$agent_fe;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const config = (0, _hooks.useConfig)();
  const maxAgentPoliciesWithInactivityTimeout = (_config$developer$max = (_config$developer = config.developer) === null || _config$developer === void 0 ? void 0 : _config$developer.maxAgentPoliciesWithInactivityTimeout) !== null && _config$developer$max !== void 0 ? _config$developer$max : _constants.DEFAULT_MAX_AGENT_POLICIES_WITH_INACTIVITY_TIMEOUT;
  const [touchedFields, setTouchedFields] = (0, _react.useState)({});
  const {
    dataOutputOptions,
    monitoringOutputOptions,
    isLoading: isLoadingOptions
  } = (0, _hooks2.useOutputOptions)(agentPolicy);
  const {
    data: agentPoliciesData
  } = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: 0,
    kuery: `${_constants.AGENT_POLICY_SAVED_OBJECT_TYPE}.inactivity_timeout:*`
  });
  const totalAgentPoliciesWithInactivityTimeout = (_agentPoliciesData$to = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.total) !== null && _agentPoliciesData$to !== void 0 ? _agentPoliciesData$to : 0;
  const tooManyAgentPoliciesForInactivityTimeout = maxAgentPoliciesWithInactivityTimeout !== undefined && totalAgentPoliciesWithInactivityTimeout > (maxAgentPoliciesWithInactivityTimeout !== null && maxAgentPoliciesWithInactivityTimeout !== void 0 ? maxAgentPoliciesWithInactivityTimeout : 0);
  const {
    dataDownloadSourceOptions,
    isLoading: isLoadingDownloadSources
  } = (0, _hooks2.useDownloadSourcesOptions)(agentPolicy);
  const {
    fleetServerHostsOptions,
    isLoading: isLoadingFleetServerHostsOption
  } = (0, _hooks2.useFleetServerHostsOptions)(agentPolicy);

  // agent monitoring checkbox group can appear multiple times in the DOM, ids have to be unique to work correctly
  const monitoringCheckboxIdSuffix = Date.now();
  const hasManagedPackagePolicy = 'package_policies' in agentPolicy && (agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.some(packagePolicy => packagePolicy.is_managed));
  const {
    agentTamperProtectionEnabled
  } = _services.ExperimentalFeaturesService.get();
  const licenseService = (0, _hooks.useLicense)();
  const [isUninstallCommandFlyoutOpen, setIsUninstallCommandFlyoutOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.descriptionFieldLabel",
      defaultMessage: "Description"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.descriptionDescription",
      defaultMessage: "Add a description of how this policy will be used."
    })
  }, isUninstallCommandFlyoutOpen && agentPolicy.id && /*#__PURE__*/_react.default.createElement(_components2.UninstallCommandFlyout, {
    target: "agent",
    policyId: agentPolicy.id,
    onClose: () => setIsUninstallCommandFlyoutOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "description",
    error: touchedFields.description && validation.description ? validation.description : null,
    isInvalid: Boolean(touchedFields.description && validation.description)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: agentPolicy.is_managed === true,
    fullWidth: true,
    value: agentPolicy.description,
    onChange: e => updateAgentPolicy({
      description: e.target.value
    }),
    isInvalid: Boolean(touchedFields.description && validation.description),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      description: true
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.descriptionFieldPlaceholder', {
      defaultMessage: 'Optional description'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", {
      "data-test-subj": "defaultNamespaceHeader"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.namespaceFieldLabel",
      defaultMessage: "Default namespace"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.namespaceFieldDescription",
      defaultMessage: "Namespaces are a user-configurable arbitrary grouping that makes it easier to search for data and manage user permissions. A policy namespace is used to name its integration's data streams. {fleetUserGuide}.",
      values: {
        fleetUserGuide: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsNamingScheme,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.fleet.agentPolicyForm.nameSpaceFieldDescription.fleetUserGuideLabel', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.namespace && validation.namespace ? validation.namespace : null,
    isInvalid: Boolean(touchedFields.namespace && validation.namespace)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: true,
    noSuggestions: true,
    selectedOptions: agentPolicy.namespace ? [{
      label: agentPolicy.namespace
    }] : [],
    onCreateOption: value => {
      updateAgentPolicy({
        namespace: value
      });
    },
    onChange: selectedOptions => {
      updateAgentPolicy({
        namespace: selectedOptions.length ? selectedOptions[0] : ''
      });
    },
    isInvalid: Boolean(touchedFields.namespace && validation.namespace),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      namespace: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringLabel",
      defaultMessage: "Agent monitoring"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringDescription",
      defaultMessage: "Collecting monitoring logs and metrics will also create an {agent} integration. Monitoring data will be written to the default namespace specified above.",
      values: {
        agent: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyPackageBadge, {
          pkgName: 'elastic_agent',
          pkgTitle: 'Elastic Agent'
        })
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    disabled: agentPolicy.is_managed === true,
    options: [{
      id: `${_constants.dataTypes.Logs}_${monitoringCheckboxIdSuffix}`,
      'data-test-subj': 'collectLogsCheckbox',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringLogsFieldLabel",
        defaultMessage: "Collect agent logs"
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.monitoringLogsTooltipText', {
          defaultMessage: 'Collect logs from Elastic Agents that use this policy.'
        }),
        position: "right",
        type: "iInCircle",
        color: "subdued"
      }))
    }, {
      id: `${_constants.dataTypes.Metrics}_${monitoringCheckboxIdSuffix}`,
      'data-test-subj': 'collectMetricsCheckbox',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringMetricsFieldLabel",
        defaultMessage: "Collect agent metrics"
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.monitoringMetricsTooltipText', {
          defaultMessage: 'Collect metrics from Elastic Agents that use this policy.'
        }),
        position: "right",
        type: "iInCircle",
        color: "subdued"
      }))
    }],
    idToSelectedMap: (agentPolicy.monitoring_enabled || []).reduce((acc, key) => {
      acc[`${key}_${monitoringCheckboxIdSuffix}`] = true;
      return acc;
    }, {
      logs: false,
      metrics: false
    }),
    onChange: longId => {
      const id = longId.split('_')[0];
      if (id !== _constants.dataTypes.Logs && id !== _constants.dataTypes.Metrics) {
        return;
      }
      const hasLogs = agentPolicy.monitoring_enabled && agentPolicy.monitoring_enabled.indexOf(id) >= 0;
      const previousValues = agentPolicy.monitoring_enabled || [];
      updateAgentPolicy({
        monitoring_enabled: hasLogs ? previousValues.filter(type => type !== id) : [...previousValues, id]
      });
    }
  })), agentTamperProtectionEnabled && licenseService.isPlatinum() && /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.tamperingLabel",
      defaultMessage: "Agent tamper protection"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.tamperingDescription",
      defaultMessage: "Prevent agents from being uninstalled locally. When enabled, agents can only be uninstalled using an authorization token in the uninstall command. Click { linkName } for the full command.",
      values: {
        linkName: /*#__PURE__*/_react.default.createElement("strong", null, "Get uninstall command")
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.tamperingSwitchLabel', {
      defaultMessage: 'Prevent agent tampering'
    }),
    checked: (_agentPolicy$is_prote = agentPolicy.is_protected) !== null && _agentPolicy$is_prote !== void 0 ? _agentPolicy$is_prote : false,
    onChange: e => {
      updateAgentPolicy({
        is_protected: e.target.checked
      });
    },
    "data-test-subj": "tamperProtectionSwitch"
  }), agentPolicy.id && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsUninstallCommandFlyoutOpen(true);
    },
    disabled: agentPolicy.is_protected === false,
    "data-test-subj": "uninstallCommandLink"
  }, _i18n.i18n.translate('xpack.fleet.agentPolicyForm.tamperingUninstallLink', {
    defaultMessage: 'Get uninstall command'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutLabel",
      defaultMessage: "Inactivity timeout"
    }), tooManyAgentPoliciesForInactivityTimeout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.inactivityTimeoutTooltip",
        defaultMessage: "The maximum of 750 agent policies with an inactivity timeout has been exceeded. Remove inactivity timeouts or agent policies to allow agents to become inactive again."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutBadge",
      defaultMessage: "Warning"
    }))))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutDescription",
      defaultMessage: "An optional timeout in seconds. If provided, an agent will automatically change to inactive status and be filtered out of the agents list. A maximum of 750 agent policies can have an inactivity timeout."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.inactivity_timeout && validation.inactivity_timeout ? validation.inactivity_timeout : null,
    isInvalid: Boolean(touchedFields.inactivity_timeout && validation.inactivity_timeout)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: agentPolicy.is_managed === true,
    value: agentPolicy.inactivity_timeout || '',
    min: 0,
    onChange: e => {
      updateAgentPolicy({
        inactivity_timeout: e.target.value ? Number(e.target.value) : 0
      });
    },
    isInvalid: Boolean(touchedFields.inactivity_timeout && validation.inactivity_timeout),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      inactivity_timeout: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.fleetServerHostsLabel",
      defaultMessage: "Fleet Server"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.fleetServerHostsDescripton",
      defaultMessage: "Select to which Fleet Server the agents in this policy will communicate."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.fleet_server_host_id && validation.fleet_server_host_id ? validation.fleet_server_host_id : null,
    isInvalid: Boolean(touchedFields.fleet_server_host_id && validation.fleet_server_host_id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: agentPolicy.is_managed === true,
    valueOfSelected: agentPolicy.fleet_server_host_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingFleetServerHostsOption,
    onChange: e => {
      updateAgentPolicy({
        fleet_server_host_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: fleetServerHostsOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.dataOutputLabel",
      defaultMessage: "Output for integrations"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.dataOutputDescription",
      defaultMessage: "Select which output to use for data from integrations."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.data_output_id && validation.data_output_id ? validation.data_output_id : null,
    isInvalid: Boolean(touchedFields.data_output_id && validation.data_output_id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: agentPolicy.is_managed === true,
    valueOfSelected: agentPolicy.data_output_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingOptions,
    onChange: e => {
      updateAgentPolicy({
        data_output_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: dataOutputOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringOutputLabel",
      defaultMessage: "Output for agent monitoring"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringOutputDescription",
      defaultMessage: "Select which output to use for the agents own monitoring data."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.monitoring_output_id && validation.monitoring_output_id ? validation.monitoring_output_id : null,
    isInvalid: Boolean(touchedFields.monitoring_output_id && validation.monitoring_output_id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: agentPolicy.is_managed === true,
    valueOfSelected: agentPolicy.monitoring_output_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingOptions,
    onChange: e => {
      updateAgentPolicy({
        monitoring_output_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: monitoringOutputOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.downloadSourceLabel",
      defaultMessage: "Agent Binary Download",
      "data-test-subj": "agentPolicyForm.downloadSource.label"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.downloadSourceDescription",
      defaultMessage: "When an upgrade action is issued the agents will download the binary from this location."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.download_source_id && validation.download_source_id ? validation.download_source_id : null,
    isInvalid: Boolean(touchedFields.download_source_id && validation.download_source_id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    valueOfSelected: agentPolicy.download_source_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingDownloadSources,
    onChange: e => {
      updateAgentPolicy({
        download_source_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: dataDownloadSourceOptions,
    "data-test-subj": "agentPolicyForm.downloadSource.select"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollmentTimeoutLabel",
      defaultMessage: "Unenrollment timeout"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.unenrollmentTimeoutTooltip', {
        defaultMessage: 'This setting is deprecated and will be removed in a future release. Consider using inactivity timeout instead'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.unenrollmentTimeoutDeprecatedLabel', {
        defaultMessage: 'Deprecated'
      }),
      size: "s"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollmentTimeoutDescription",
      defaultMessage: "An optional timeout in seconds. If provided, and fleet server is below version 8.7.0, an agent will automatically unenroll after being gone for this period of time."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.unenroll_timeout && validation.unenroll_timeout ? validation.unenroll_timeout : null,
    isInvalid: Boolean(touchedFields.unenroll_timeout && validation.unenroll_timeout)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: agentPolicy.is_managed === true,
    value: agentPolicy.unenroll_timeout || '',
    min: 0,
    onChange: e => {
      updateAgentPolicy({
        unenroll_timeout: e.target.value ? Number(e.target.value) : 0
      });
    },
    isInvalid: Boolean(touchedFields.unenroll_timeout && validation.unenroll_timeout),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      unenroll_timeout: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.hostnameFormatLabel",
      defaultMessage: "Host name format"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "beta",
      size: "s",
      color: "accent"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.hostnameFormatLabelDescription",
      defaultMessage: "Select how you would like agent domain names to be displayed."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: [{
      id: 'hostname',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionHostname",
        defaultMessage: "Hostname"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionHostnameExample",
        defaultMessage: "ex: My-Laptop"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }))
    }, {
      id: 'fqdn',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionFqdn",
        defaultMessage: "Fully Qualified Domain Name (FQDN)"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionFqdnExample",
        defaultMessage: "ex: My-Laptop.admin.acme.co"
      }))))
    }],
    idSelected: (_agentPolicy$agent_fe = agentPolicy.agent_features) !== null && _agentPolicy$agent_fe !== void 0 && _agentPolicy$agent_fe.length ? 'fqdn' : 'hostname',
    onChange: id => {
      updateAgentPolicy({
        agent_features: id === 'hostname' ? [] : [{
          name: 'fqdn',
          enabled: true
        }]
      });
    },
    name: "radio group"
  }))), isEditing && 'id' in agentPolicy && !agentPolicy.is_managed ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.deletePolicyGroupTitle",
      defaultMessage: "Delete policy"
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.deletePolicyGroupDescription",
      defaultMessage: "Existing data will not be deleted."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_agent_policy_delete_provider.AgentPolicyDeleteProvider, {
      hasFleetServer: (0, _services.policyHasFleetServer)(agentPolicy)
    }, deleteAgentPolicyPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: hasManagedPackagePolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyForm.deletePolicyActionText.disabled",
          defaultMessage: "Agent policy with managed package policies cannot be deleted."
        }) : undefined
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "agentPolicyForm.downloadSource.deleteBtn",
        color: "danger",
        onClick: () => deleteAgentPolicyPrompt(agentPolicy.id, onDelete),
        isDisabled: hasManagedPackagePolicy
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyForm.deletePolicyActionText",
        defaultMessage: "Delete policy"
      })));
    }))
  }) : null);
};
exports.AgentPolicyAdvancedOptionsContent = AgentPolicyAdvancedOptionsContent;