"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaitForFleetServer = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_INTERVAL = 10000;

/**
 * Polls the Fleet status endpoint until the `fleet_server` requirement does not appear
 * in the `missing_requirements` list.
 */
const useWaitForFleetServer = () => {
  var _fleetStatus$missingR;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const isFleetServerReady = fleetStatus.isReady && !((_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 && _fleetStatus$missingR.includes('fleet_server'));
  (0, _react.useEffect)(() => {
    let interval = null;
    if (!isFleetServerReady) {
      interval = setInterval(async () => {
        try {
          if (isFleetServerReady) {
            if (interval) {
              clearInterval(interval);
            }
          } else {
            fleetStatus.setForceDisplayInstructions(true);
            fleetStatus.refresh();
          }
        } catch (err) {
          notifications.toasts.addError(err, {
            title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.errorRefreshingFleetServerStatus', {
              defaultMessage: 'Error refreshing Fleet Server status'
            })
          });
        }
      }, REFRESH_INTERVAL);
    }
    const cleanup = () => {
      if (interval) {
        clearInterval(interval);
      }
    };
    return cleanup;
  }, [notifications.toasts, isFleetServerReady, fleetStatus]);
  return {
    isFleetServerReady
  };
};
exports.useWaitForFleetServer = useWaitForFleetServer;