"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getXyChartRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const extractCounterEvents = (originatingApp, {
  layers,
  yAxisConfigs
}, canNavigateToLens, services) => {
  const dataLayers = services.getDataLayers(layers);
  if (dataLayers.length) {
    var _dataLayer$splitAcces, _dataLayer$splitAcces2;
    const [dataLayer] = dataLayers;
    const type = dataLayer.seriesType === _constants.SeriesTypes.BAR ? `${dataLayer.isHorizontal ? 'horizontal_bar' : 'vertical_bar'}` : dataLayer.seriesType;
    const byTypes = layers.reduce((acc, item) => {
      if (!acc.mixedXY && item.layerType === _constants.LayerTypes.DATA && item.seriesType !== dataLayer.seriesType) {
        acc.mixedXY = true;
      }
      acc[item.layerType] += 1;
      return acc;
    }, {
      mixedXY: false,
      [_constants.LayerTypes.REFERENCELINE]: 0,
      [_constants.LayerTypes.ANNOTATIONS]: 0,
      [_constants.LayerTypes.DATA]: 0
    });

    // Multiple axes configured on the same side of the chart
    const multiAxisSide = Object.values((yAxisConfigs !== null && yAxisConfigs !== void 0 ? yAxisConfigs : []).reduce((acc, item) => {
      if (item.position) {
        var _acc$item$position;
        acc[item.position] = ((_acc$item$position = acc[item.position]) !== null && _acc$item$position !== void 0 ? _acc$item$position : 0) + 1;
      }
      return acc;
    }, {})).find(i => i > 1);
    const multiSplitNonTerms = ((_dataLayer$splitAcces = dataLayer.splitAccessors) !== null && _dataLayer$splitAcces !== void 0 ? _dataLayer$splitAcces : []).map(splitAccessor => {
      var _getColumnByAccessor, _getColumnByAccessor$, _getColumnByAccessor$2, _getColumnByAccessor$3;
      return (_getColumnByAccessor = (0, _utils.getColumnByAccessor)(splitAccessor, dataLayer.table.columns)) === null || _getColumnByAccessor === void 0 ? void 0 : (_getColumnByAccessor$ = _getColumnByAccessor.meta) === null || _getColumnByAccessor$ === void 0 ? void 0 : (_getColumnByAccessor$2 = _getColumnByAccessor$.sourceParams) === null || _getColumnByAccessor$2 === void 0 ? void 0 : (_getColumnByAccessor$3 = _getColumnByAccessor$2.type) === null || _getColumnByAccessor$3 === void 0 ? void 0 : _getColumnByAccessor$3.toString();
    }).filter(Boolean);
    const aggregateLayers = dataLayers.map(l => l.accessors.reduce((acc, accessor) => {
      var _getColumnByAccessor2, _getColumnByAccessor3, _getColumnByAccessor4, _getColumnByAccessor5;
      const metricType = (_getColumnByAccessor2 = (0, _utils.getColumnByAccessor)(accessor, l.table.columns)) === null || _getColumnByAccessor2 === void 0 ? void 0 : (_getColumnByAccessor3 = _getColumnByAccessor2.meta) === null || _getColumnByAccessor3 === void 0 ? void 0 : (_getColumnByAccessor4 = _getColumnByAccessor3.sourceParams) === null || _getColumnByAccessor4 === void 0 ? void 0 : (_getColumnByAccessor5 = _getColumnByAccessor4.type) === null || _getColumnByAccessor5 === void 0 ? void 0 : _getColumnByAccessor5.toString();
      if (metricType && ['avg_bucket', 'min_bucket', 'max_bucket', 'sum_bucket'].includes(metricType)) {
        acc.push(metricType);
      }
      return acc;
    }, [])).flat();
    return [[type, dataLayer.isPercentage ? 'percentage' : undefined, dataLayer.isStacked ? 'stacked' : undefined
    // There's a metric configured for the dot size in an area or line chart
    ].filter(Boolean).join('_'), byTypes[_constants.LayerTypes.REFERENCELINE] ? 'reference_layer' : undefined, byTypes[_constants.LayerTypes.ANNOTATIONS] ? 'annotation_layer' : undefined, byTypes[_constants.LayerTypes.DATA] > 1 ? 'multiple_data_layers' : undefined, byTypes.mixedXY ? 'mixed_xy' : undefined, dataLayer.markSizeAccessor ? 'metric_dot_size' : undefined, multiAxisSide ? 'multi_axis_same_side' : undefined,
    // There are multiple "split series" aggs in an xy chart and they are not all terms but other aggs
    multiSplitNonTerms.length > 1 && !multiSplitNonTerms.every(i => i === 'terms') ? 'multi_split_non_terms' : undefined,
    // Multiple average/min/max/sum bucket aggs in a single vis or
    // one average/min/max/sum bucket aggs on an xy chart with at least one "split series" defined
    aggregateLayers.length > 1 || aggregateLayers.length === 1 && (_dataLayer$splitAcces2 = dataLayer.splitAccessors) !== null && _dataLayer$splitAcces2 !== void 0 && _dataLayer$splitAcces2.length ? 'aggregate_bucket' : undefined, canNavigateToLens ? `render_${byTypes.mixedXY ? 'mixed_xy' : type}_convertable` : undefined].filter(Boolean).map(item => `render_${originatingApp}_${item}`);
  }
};

/**
 * Retrieves the compatible CELL_VALUE_TRIGGER actions indexed by layer
 **/
const getLayerCellValueActions = async (layers, getCompatibleCellValueActions) => {
  if (!layers || !getCompatibleCellValueActions) {
    return [];
  }
  return await Promise.all(layers.map(layer => {
    var _layer$splitAccessors, _layer$splitAccessors2;
    const data = (_layer$splitAccessors = (_layer$splitAccessors2 = layer.splitAccessors) === null || _layer$splitAccessors2 === void 0 ? void 0 : _layer$splitAccessors2.map(accessor => {
      const column = layer.table.columns.find(({
        id
      }) => id === accessor);
      return {
        columnMeta: column === null || column === void 0 ? void 0 : column.meta
      };
    })) !== null && _layer$splitAccessors !== void 0 ? _layer$splitAccessors : [];
    return getCompatibleCellValueActions(data);
  }));
};
const getXyChartRenderer = ({
  getStartDeps
}) => ({
  name: 'xyVis',
  displayName: 'XY chart',
  help: _i18n.i18n.translate('expressionXY.xyVis.renderer.help', {
    defaultMessage: 'X/Y chart renderer'
  }),
  validate: () => undefined,
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const deps = await getStartDeps();

    // Lazy loaded parts
    const [{
      XYChartReportable
    }, {
      calculateMinInterval,
      getDataLayers
    }] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../components/xy_chart'))), Promise.resolve().then(() => _interopRequireWildcard(require('../helpers')))]);
    handlers.onDestroy(() => _reactDom.default.unmountComponentAtNode(domNode));
    const onClickValue = data => {
      handlers.event({
        name: 'filter',
        data
      });
    };
    const onSelectRange = data => {
      handlers.event({
        name: 'brush',
        data
      });
    };
    const onClickMultiValue = data => {
      handlers.event({
        name: 'multiFilter',
        data
      });
    };
    const layerCellValueActions = await getLayerCellValueActions(getDataLayers(config.args.layers), handlers.getCompatibleCellValueActions);
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (deps.usageCollection && containerType && visualizationType) {
        const uiEvents = extractCounterEvents(visualizationType, config.args, Boolean(config.canNavigateToLens), {
          getDataLayers
        });
        if (uiEvents) {
          deps.usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, uiEvents);
        }
      }
      handlers.done();
    };
    const chartContainerStyle = (0, _react.css)({
      position: 'relative',
      width: '100%',
      height: '100%'
    });
    _reactDom.default.render( /*#__PURE__*/_react2.default.createElement(_public.KibanaThemeProvider, {
      theme$: deps.kibanaTheme.theme$
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react2.default.createElement("div", {
      css: chartContainerStyle,
      "data-test-subj": "xyVisChart"
    }, /*#__PURE__*/_react2.default.createElement(XYChartReportable, (0, _extends2.default)({}, config, {
      data: deps.data,
      formatFactory: deps.formatFactory,
      chartsActiveCursorService: deps.activeCursor,
      chartsThemeService: deps.theme,
      paletteService: deps.paletteService,
      timeZone: deps.timeZone,
      timeFormat: deps.timeFormat,
      eventAnnotationService: deps.eventAnnotationService,
      useLegacyTimeAxis: deps.useLegacyTimeAxis,
      minInterval: calculateMinInterval(deps.data.datatableUtilities, config),
      interactive: handlers.isInteractive(),
      onClickValue: onClickValue,
      onClickMultiValue: onClickMultiValue,
      layerCellValueActions: layerCellValueActions,
      onSelectRange: onSelectRange,
      renderMode: handlers.getRenderMode(),
      syncColors: config.syncColors,
      syncTooltips: config.syncTooltips,
      syncCursor: config.syncCursor,
      uiState: handlers.uiState,
      renderComplete: renderComplete
    }))))), domNode);
  }
});
exports.getXyChartRenderer = getXyChartRenderer;