"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionTagcloudPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _expression_renderers = require("./expression_renderers");
var _expression_functions = require("../common/expression_functions");
var _format_service = require("./format_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ExpressionTagcloudPlugin {
  setup(core, {
    expressions,
    charts
  }) {
    const getStartDeps = (0, _public.createStartServicesGetter)(core.getStartServices);
    expressions.registerFunction(_expression_functions.tagcloudFunction);
    expressions.registerRenderer((0, _expression_renderers.tagcloudRenderer)({
      getStartDeps
    }));
  }
  start(core, {
    fieldFormats
  }) {
    (0, _format_service.setFormatService)(fieldFormats);
  }
  stop() {}
}
exports.ExpressionTagcloudPlugin = ExpressionTagcloudPlugin;