"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACCORDION_LABEL = void 0;
exports.Series = Series;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _series_actions = require("./columns/series_actions");
var _series_info = require("./columns/series_info");
var _data_type_select = require("./columns/data_type_select");
var _incomplete_badge = require("./columns/incomplete_badge");
var _expanded_series_row = require("./expanded_series_row");
var _series_name = require("./columns/series_name");
var _report_metric_options = require("./report_metric_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .euiAccordion__button {
    width: auto;
    flex-grow: 0;
  }

  .euiAccordion__optionalAction {
    flex-grow: 1;
    flex-shrink: 1;
  }

  .euiAccordion__childWrapper {
    overflow: visible;
  }
`;
function Series({
  item,
  isExpanded,
  toggleExpanded
}) {
  const {
    id
  } = item;
  const seriesProps = {
    ...item,
    seriesId: id
  };
  const [isExpandedOnce, setIsExpandedOnce] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (isExpanded) {
      setIsExpandedOnce(true);
    }
  }, [isExpanded]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": `exploratoryViewSeriesPanel${0}`,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(StyledAccordion, {
    id: `exploratoryViewSeriesAccordion${id}`,
    forceState: isExpanded ? 'open' : 'closed',
    "aria-label": ACCORDION_LABEL,
    onToggle: toggleExpanded,
    arrowDisplay: !seriesProps.series.dataType ? 'none' : undefined,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_series_info.SeriesInfo, seriesProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_series_name.SeriesName, seriesProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_data_type_select.DataTypesSelect, seriesProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_report_metric_options.ReportMetricOptions, seriesProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_incomplete_badge.IncompleteBadge, seriesProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_series_actions.SeriesActions, (0, _extends2.default)({}, seriesProps, {
      onEditClick: !isExpanded ? toggleExpanded : undefined
    }))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, isExpandedOnce && /*#__PURE__*/_react.default.createElement(_expanded_series_row.ExpandedSeriesRow, seriesProps))));
}
const ACCORDION_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.accordion.label', {
  defaultMessage: 'Toggle series information'
});
exports.ACCORDION_LABEL = ACCORDION_LABEL;