"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DataTypes", {
  enumerable: true,
  get: function () {
    return _labels.DataTypes;
  }
});
exports.ExploratoryViewPage = ExploratoryViewPage;
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _exploratory_view = require("./exploratory_view");
var _use_app_data_view = require("./hooks/use_app_data_view");
var _use_series_storage = require("./hooks/use_series_storage");
var _refresh_button = require("./header/refresh_button");
var _labels = require("./labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = _i18n.i18n.translate('xpack.exploratoryView.expView.heading.label', {
  defaultMessage: 'Explore data'
});
function ExploratoryViewPage({
  app,
  saveAttributes,
  useSessionStorage = false
}) {
  const {
    services: {
      uiSettings,
      notifications,
      observabilityShared
    }
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  (0, _public3.useTrackPageview)({
    app: 'observability-overview',
    path: 'exploratory-view'
  });
  (0, _public3.useTrackPageview)({
    app: 'observability-overview',
    path: 'exploratory-view',
    delay: 15000
  });
  (0, _public3.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.exploratoryView.overview', {
      defaultMessage: 'Explore data'
    })
  }], app);
  const kbnUrlStateStorage = useSessionStorage ? (0, _public2.createSessionStorageStateStorage)() : (0, _public2.createKbnUrlStateStorage)({
    history,
    useHash: uiSettings.get('state:storeInSessionStorage'),
    ...(0, _public2.withNotifyOnErrors)(notifications.toasts)
  });
  return /*#__PURE__*/_react.default.createElement(_use_series_storage.UrlStorageContextProvider, {
    storage: kbnUrlStateStorage
  }, /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: PAGE_TITLE,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_refresh_button.RefreshButton, null)]
    }
  }, /*#__PURE__*/_react.default.createElement(_use_app_data_view.DataViewContextProvider, null, /*#__PURE__*/_react.default.createElement(_exploratory_view.ExploratoryView, {
    saveAttributes: saveAttributes
  }))));
}

// eslint-disable-next-line import/no-default-export
var _default = ExploratoryViewPage;
exports.default = _default;