"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rumFieldFormats = void 0;
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rumFieldFormats = [{
  field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'asSeconds',
      showSuffix: true,
      outputPrecision: 1,
      useShortSuffix: true
    }
  }
}, {
  field: _elasticsearch_fieldnames.FCP_FIELD,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'milliseconds',
      outputFormat: 'humanizePrecise',
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _elasticsearch_fieldnames.LCP_FIELD,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'milliseconds',
      outputFormat: 'humanizePrecise',
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _elasticsearch_fieldnames.TBT_FIELD,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'milliseconds',
      outputFormat: 'humanizePrecise',
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _elasticsearch_fieldnames.FID_FIELD,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'milliseconds',
      outputFormat: 'humanizePrecise',
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'milliseconds',
      outputFormat: 'humanizePrecise',
      showSuffix: true,
      useShortSuffix: true
    }
  }
}];
exports.rumFieldFormats = rumFieldFormats;