"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USE_BREAK_DOWN_COLUMN = exports.TERMS_COLUMN = exports.ReportTypes = exports.REPORT_METRIC_TIMESTAMP = exports.REPORT_METRIC_FIELD = exports.RECORDS_PERCENTAGE_FIELD = exports.RECORDS_FIELD = exports.PERCENTILE_RANKS = exports.PERCENTILE = exports.OPERATION_COLUMN = exports.LABEL_FIELDS_FILTER = exports.LABEL_FIELDS_BREAKDOWN = exports.FieldLabels = exports.FORMULA_COLUMN = exports.FILTER_RECORDS = exports.ENVIRONMENT_ALL = exports.DataViewLabels = exports.DEFAULT_TIME = void 0;
var _constants = require("@kbn/lens-plugin/common/constants");
var _i18n = require("@kbn/i18n");
var _elasticsearch_fieldnames = require("./elasticsearch_fieldnames");
var _labels = require("./labels");
var _synthetics = require("./field_names/synthetics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIME = {
  from: 'now-1h',
  to: 'now'
};
exports.DEFAULT_TIME = DEFAULT_TIME;
const RECORDS_FIELD = _constants.DOCUMENT_FIELD_NAME;
exports.RECORDS_FIELD = RECORDS_FIELD;
const RECORDS_PERCENTAGE_FIELD = 'RecordsPercentage';
exports.RECORDS_PERCENTAGE_FIELD = RECORDS_PERCENTAGE_FIELD;
const FORMULA_COLUMN = 'FORMULA_COLUMN';
exports.FORMULA_COLUMN = FORMULA_COLUMN;
const FieldLabels = {
  'user_agent.name': _labels.BROWSER_FAMILY_LABEL,
  'user_agent.version': _labels.BROWSER_VERSION_LABEL,
  'user_agent.os.name': _labels.OS_LABEL,
  'client.geo.country_name': _labels.LOCATION_LABEL,
  'user_agent.device.name': _labels.DEVICE_LABEL,
  'observer.geo.name': _labels.OBSERVER_LOCATION_LABEL,
  'service.name': _labels.SERVICE_NAME_LABEL,
  'service.environment': _labels.ENVIRONMENT_LABEL,
  'service.type': _labels.SERVICE_TYPE_LABEL,
  'event.dataset': _labels.EVENT_DATASET_LABEL,
  message: _labels.MESSAGE_LABEL,
  [_elasticsearch_fieldnames.LCP_FIELD]: _labels.LCP_LABEL,
  [_elasticsearch_fieldnames.FCP_FIELD]: _labels.FCP_LABEL,
  [_elasticsearch_fieldnames.TBT_FIELD]: _labels.TBT_LABEL,
  [_elasticsearch_fieldnames.FID_FIELD]: _labels.FID_LABEL,
  [_elasticsearch_fieldnames.CLS_FIELD]: _labels.CLS_LABEL,
  [_synthetics.SYNTHETICS_CLS]: _labels.CLS_LABEL,
  [_synthetics.SYNTHETICS_DCL]: _labels.DCL_LABEL,
  [_synthetics.SYNTHETICS_STEP_DURATION]: _labels.STEP_DURATION_LABEL,
  [_synthetics.SYNTHETICS_LCP]: _labels.LCP_LABEL,
  [_synthetics.SYNTHETICS_FCP]: _labels.FCP_LABEL,
  [_synthetics.SYNTHETICS_DOCUMENT_ONLOAD]: _labels.PAGE_LOAD_TIME_LABEL,
  [_elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE]: _labels.BACKEND_TIME_LABEL,
  [_elasticsearch_fieldnames.TRANSACTION_DURATION]: _labels.PAGE_LOAD_TIME_LABEL,
  [_synthetics.SYNTHETICS_CONNECT_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.connect', {
    defaultMessage: 'Connect'
  }),
  [_synthetics.SYNTHETICS_DNS_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.dns', {
    defaultMessage: 'DNS'
  }),
  [_synthetics.SYNTHETICS_WAIT_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.wait', {
    defaultMessage: 'Wait'
  }),
  [_synthetics.SYNTHETICS_SSL_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.ssl', {
    defaultMessage: 'SSL'
  }),
  [_synthetics.SYNTHETICS_BLOCKED_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.blocked', {
    defaultMessage: 'Blocked'
  }),
  [_synthetics.SYNTHETICS_SEND_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.send', {
    defaultMessage: 'Send'
  }),
  [_synthetics.SYNTHETICS_RECEIVE_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.receive', {
    defaultMessage: 'Receive'
  }),
  [_synthetics.SYNTHETICS_TOTAL_TIMINGS]: _i18n.i18n.translate('xpack.exploratoryView.expView.synthetics.total', {
    defaultMessage: 'Total'
  }),
  'kibana.alert.rule.category': _i18n.i18n.translate('xpack.exploratoryView.expView.alerts.category', {
    defaultMessage: 'Rule category'
  }),
  'kibana.alert.rule.name': _i18n.i18n.translate('xpack.exploratoryView.expView.alerts.name', {
    defaultMessage: 'Alert name'
  }),
  'kibana.alert.status': _i18n.i18n.translate('xpack.exploratoryView.expView.alerts.status', {
    defaultMessage: 'Alert status'
  }),
  'monitor.id': _labels.MONITOR_ID_LABEL,
  'monitor.status': _labels.MONITOR_STATUS_LABEL,
  [_synthetics.MONITOR_DURATION_US]: _labels.MONITORS_DURATION_LABEL,
  [_synthetics.SYNTHETICS_STEP_NAME]: _labels.STEP_NAME_LABEL,
  'agent.hostname': _labels.AGENT_HOST_LABEL,
  'agent.type': _labels.AGENT_TYPE_LABEL,
  'host.hostname': _labels.HOST_NAME_LABEL,
  'monitor.name': _labels.MONITOR_NAME_LABEL,
  'monitor.type': _labels.MONITOR_TYPE_LABEL,
  'url.port': _labels.PORT_LABEL,
  'url.full': _labels.URL_LABEL,
  tags: _labels.TAGS_LABEL,
  // custom

  'performance.metric': _labels.METRIC_LABEL,
  'Business.KPI': _labels.KPI_LABEL,
  'http.request.method': _labels.REQUEST_METHOD,
  percentile: 'Percentile',
  LABEL_FIELDS_FILTER: _labels.LABELS_FIELD,
  LABEL_FIELDS_BREAKDOWN: 'Labels field'
};
exports.FieldLabels = FieldLabels;
const DataViewLabels = {
  'data-distribution': _labels.PERF_DIST_LABEL,
  'kpi-over-time': _labels.KPI_OVER_TIME_LABEL,
  'core-web-vitals': _labels.CORE_WEB_VITALS_LABEL,
  'device-data-distribution': _labels.DEVICE_DISTRIBUTION_LABEL,
  'single-metric': _labels.SINGLE_METRIC_LABEL,
  heatmap: _labels.HEATMAP_LABEL
};
exports.DataViewLabels = DataViewLabels;
let ReportTypes;
exports.ReportTypes = ReportTypes;
(function (ReportTypes) {
  ReportTypes["KPI"] = "kpi-over-time";
  ReportTypes["DISTRIBUTION"] = "data-distribution";
  ReportTypes["CORE_WEB_VITAL"] = "core-web-vitals";
  ReportTypes["DEVICE_DISTRIBUTION"] = "device-data-distribution";
  ReportTypes["SINGLE_METRIC"] = "single-metric";
  ReportTypes["HEATMAP"] = "heatmap";
})(ReportTypes || (exports.ReportTypes = ReportTypes = {}));
const USE_BREAK_DOWN_COLUMN = 'USE_BREAK_DOWN_COLUMN';
exports.USE_BREAK_DOWN_COLUMN = USE_BREAK_DOWN_COLUMN;
const FILTER_RECORDS = 'FILTER_RECORDS';
exports.FILTER_RECORDS = FILTER_RECORDS;
const TERMS_COLUMN = 'TERMS_COLUMN';
exports.TERMS_COLUMN = TERMS_COLUMN;
const OPERATION_COLUMN = 'operation';
exports.OPERATION_COLUMN = OPERATION_COLUMN;
const PERCENTILE = 'percentile';
exports.PERCENTILE = PERCENTILE;
const REPORT_METRIC_FIELD = 'REPORT_METRIC_FIELD';
exports.REPORT_METRIC_FIELD = REPORT_METRIC_FIELD;
const REPORT_METRIC_TIMESTAMP = 'REPORT_METRIC_FIELD_TIMESTAMP';
exports.REPORT_METRIC_TIMESTAMP = REPORT_METRIC_TIMESTAMP;
const PERCENTILE_RANKS = ['99th', '95th', '90th', '75th', '50th', '25th'];
exports.PERCENTILE_RANKS = PERCENTILE_RANKS;
const LABEL_FIELDS_FILTER = 'LABEL_FIELDS_FILTER';
exports.LABEL_FIELDS_FILTER = LABEL_FIELDS_FILTER;
const LABEL_FIELDS_BREAKDOWN = 'LABEL_FIELDS_BREAKDOWN';
exports.LABEL_FIELDS_BREAKDOWN = LABEL_FIELDS_BREAKDOWN;
const ENVIRONMENT_ALL = 'ENVIRONMENT_ALL';
exports.ENVIRONMENT_ALL = ENVIRONMENT_ALL;