"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationList = void 0;
var _react = require("@emotion/react");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _public = require("@kbn/visualization-ui-components/public");
var _react2 = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AnnotationList = ({
  annotations,
  selectAnnotation,
  update: updateAnnotations
}) => {
  const [newAnnotationId, setNewAnnotationId] = (0, _react2.useState)((0, _uuid.v4)());
  (0, _react2.useEffect)(() => {
    setNewAnnotationId((0, _uuid.v4)());
  }, [annotations.length]);
  const {
    dragging
  } = (0, _react2.useContext)(_domDragDrop.DragContext);
  const addAnnotationText = _i18n.i18n.translate('eventAnnotation.annotationList.add', {
    defaultMessage: 'Add annotation'
  });
  const addNewAnnotation = (0, _react2.useCallback)(sourceAnnotationId => {
    const source = sourceAnnotationId ? annotations.find(({
      id
    }) => id === sourceAnnotationId) : undefined;
    const newAnnotation = (0, _common.createCopiedAnnotation)(newAnnotationId, new Date().toISOString(), source);
    if (!source) {
      selectAnnotation(newAnnotation);
    }
    updateAnnotations([...annotations, newAnnotation]);
  }, [annotations, newAnnotationId, selectAnnotation, updateAnnotations]);
  return /*#__PURE__*/_react2.default.createElement("div", null, annotations.map((annotation, index) => /*#__PURE__*/_react2.default.createElement("div", {
    key: index,
    css: (0, _react.css)`
            margin-top: ${_uiTheme.euiThemeVars.euiSizeS};
            position: relative; // this is to properly contain the absolutely-positioned drop target in DragDrop
          `
  }, /*#__PURE__*/_react2.default.createElement(_domDragDrop.DragDrop, {
    order: [index],
    key: annotation.id,
    value: {
      id: annotation.id,
      humanData: {
        label: annotation.label
      }
    },
    dragType: "copy",
    dropTypes: [],
    draggable: true
  }, /*#__PURE__*/_react2.default.createElement(_public.DimensionButton, {
    groupLabel: _i18n.i18n.translate('eventAnnotation.groupEditor.addAnnotation', {
      defaultMessage: 'Annotations'
    }),
    onClick: () => selectAnnotation(annotation),
    onRemoveClick: () => updateAnnotations(annotations.filter(({
      id
    }) => id !== annotation.id)),
    accessorConfig: (0, _.getAnnotationAccessor)(annotation),
    label: annotation.label
  }, /*#__PURE__*/_react2.default.createElement(_public.DimensionTrigger, {
    label: annotation.label
  }))))), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          margin-top: ${_uiTheme.euiThemeVars.euiSizeS};
        `
  }, /*#__PURE__*/_react2.default.createElement(_domDragDrop.DragDrop, {
    order: [annotations.length],
    getCustomDropTarget: _domDragDrop.DropTargetSwapDuplicateCombine.getCustomDropTarget,
    getAdditionalClassesOnDroppable: _domDragDrop.DropTargetSwapDuplicateCombine.getAdditionalClassesOnDroppable,
    dropTypes: dragging ? ['field_add'] : [],
    value: {
      id: 'addAnnotation',
      humanData: {
        label: addAnnotationText
      }
    },
    onDrop: ({
      id: sourceId
    }) => addNewAnnotation(sourceId)
  }, /*#__PURE__*/_react2.default.createElement(_public.EmptyDimensionButton, {
    dataTestSubj: "addAnnotation",
    label: addAnnotationText,
    ariaLabel: addAnnotationText,
    onClick: () => addNewAnnotation()
  }))));
};
exports.AnnotationList = AnnotationList;